package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.Port
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PortRangeFilter(
    beginInclusive: Optional[Port] = Optional.Absent,
    endInclusive: Optional[Port] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PortRangeFilter = {
    import PortRangeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PortRangeFilter
      .builder()
      .optionallyWith(beginInclusive.map(value => Port.unwrap(value): Integer))(
        _.beginInclusive
      )
      .optionallyWith(endInclusive.map(value => Port.unwrap(value): Integer))(
        _.endInclusive
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.PortRangeFilter.ReadOnly =
    zio.aws.inspector2.model.PortRangeFilter.wrap(buildAwsValue())
}
object PortRangeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PortRangeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PortRangeFilter =
      zio.aws.inspector2.model.PortRangeFilter(
        beginInclusive.map(value => value),
        endInclusive.map(value => value)
      )
    def beginInclusive: Optional[Port]
    def endInclusive: Optional[Port]
    def getBeginInclusive: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("beginInclusive", beginInclusive)
    def getEndInclusive: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("endInclusive", endInclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PortRangeFilter
  ) extends zio.aws.inspector2.model.PortRangeFilter.ReadOnly {
    override val beginInclusive: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.beginInclusive())
      .map(value => zio.aws.inspector2.model.primitives.Port(value))
    override val endInclusive: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.endInclusive())
      .map(value => zio.aws.inspector2.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PortRangeFilter
  ): zio.aws.inspector2.model.PortRangeFilter.ReadOnly = new Wrapper(impl)
}
