package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ReportingErrorCode {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.ReportingErrorCode
}
object ReportingErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ReportingErrorCode
  ): zio.aws.inspector2.model.ReportingErrorCode = value match {
    case software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.INVALID_PERMISSIONS =>
      val r = INVALID_PERMISSIONS
      r
    case software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.NO_FINDINGS_FOUND =>
      val r = NO_FINDINGS_FOUND
      r
    case software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.BUCKET_NOT_FOUND =>
      val r = BUCKET_NOT_FOUND
      r
    case software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.INCOMPATIBLE_BUCKET_REGION =>
      val r = INCOMPATIBLE_BUCKET_REGION
      r
    case software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.MALFORMED_KMS_KEY =>
      val r = MALFORMED_KMS_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ReportingErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportingErrorCode =
      software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.inspector2.model.ReportingErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportingErrorCode =
      software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.INTERNAL_ERROR
  }
  case object INVALID_PERMISSIONS
      extends zio.aws.inspector2.model.ReportingErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportingErrorCode =
      software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.INVALID_PERMISSIONS
  }
  case object NO_FINDINGS_FOUND
      extends zio.aws.inspector2.model.ReportingErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportingErrorCode =
      software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.NO_FINDINGS_FOUND
  }
  case object BUCKET_NOT_FOUND
      extends zio.aws.inspector2.model.ReportingErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportingErrorCode =
      software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.BUCKET_NOT_FOUND
  }
  case object INCOMPATIBLE_BUCKET_REGION
      extends zio.aws.inspector2.model.ReportingErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportingErrorCode =
      software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.INCOMPATIBLE_BUCKET_REGION
  }
  case object MALFORMED_KMS_KEY
      extends zio.aws.inspector2.model.ReportingErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportingErrorCode =
      software.amazon.awssdk.services.inspector2.model.ReportingErrorCode.MALFORMED_KMS_KEY
  }
}
