package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceStatus(
    ec2: zio.aws.inspector2.model.Status,
    ecr: zio.aws.inspector2.model.Status,
    lambda: Optional[zio.aws.inspector2.model.Status] = Optional.Absent,
    lambdaCode: Optional[zio.aws.inspector2.model.Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceStatus = {
    import ResourceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceStatus
      .builder()
      .ec2(ec2.unwrap)
      .ecr(ecr.unwrap)
      .optionallyWith(lambda.map(value => value.unwrap))(_.lambda)
      .optionallyWith(lambdaCode.map(value => value.unwrap))(_.lambdaCode)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceStatus.ReadOnly =
    zio.aws.inspector2.model.ResourceStatus.wrap(buildAwsValue())
}
object ResourceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceStatus =
      zio.aws.inspector2.model.ResourceStatus(
        ec2,
        ecr,
        lambda.map(value => value),
        lambdaCode.map(value => value)
      )
    def ec2: zio.aws.inspector2.model.Status
    def ecr: zio.aws.inspector2.model.Status
    def lambda: Optional[zio.aws.inspector2.model.Status]
    def lambdaCode: Optional[zio.aws.inspector2.model.Status]
    def getEc2: ZIO[Any, Nothing, zio.aws.inspector2.model.Status] =
      ZIO.succeed(ec2)
    def getEcr: ZIO[Any, Nothing, zio.aws.inspector2.model.Status] =
      ZIO.succeed(ecr)
    def getLambda: ZIO[Any, AwsError, zio.aws.inspector2.model.Status] =
      AwsError.unwrapOptionField("lambda", lambda)
    def getLambdaCode: ZIO[Any, AwsError, zio.aws.inspector2.model.Status] =
      AwsError.unwrapOptionField("lambdaCode", lambdaCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceStatus
  ) extends zio.aws.inspector2.model.ResourceStatus.ReadOnly {
    override val ec2: zio.aws.inspector2.model.Status =
      zio.aws.inspector2.model.Status.wrap(impl.ec2())
    override val ecr: zio.aws.inspector2.model.Status =
      zio.aws.inspector2.model.Status.wrap(impl.ecr())
    override val lambda: Optional[zio.aws.inspector2.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambda())
        .map(value => zio.aws.inspector2.model.Status.wrap(value))
    override val lambdaCode: Optional[zio.aws.inspector2.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaCode())
        .map(value => zio.aws.inspector2.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceStatus
  ): zio.aws.inspector2.model.ResourceStatus.ReadOnly = new Wrapper(impl)
}
