package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceStringComparison {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ResourceStringComparison
}
object ResourceStringComparison {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ResourceStringComparison
  ): zio.aws.inspector2.model.ResourceStringComparison = value match {
    case software.amazon.awssdk.services.inspector2.model.ResourceStringComparison.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ResourceStringComparison.EQUALS =>
      val r = EQUALS
      r
    case software.amazon.awssdk.services.inspector2.model.ResourceStringComparison.NOT_EQUALS =>
      val r = NOT_EQUALS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ResourceStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceStringComparison =
      software.amazon.awssdk.services.inspector2.model.ResourceStringComparison.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.inspector2.model.ResourceStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceStringComparison =
      software.amazon.awssdk.services.inspector2.model.ResourceStringComparison.EQUALS
  }
  case object NOT_EQUALS
      extends zio.aws.inspector2.model.ResourceStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceStringComparison =
      software.amazon.awssdk.services.inspector2.model.ResourceStringComparison.NOT_EQUALS
  }
}
