package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ResourceType
  ): zio.aws.inspector2.model.ResourceType = value match {
    case software.amazon.awssdk.services.inspector2.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ResourceType.AWS_EC2_INSTANCE =>
      val r = AWS_EC2_INSTANCE
      r
    case software.amazon.awssdk.services.inspector2.model.ResourceType.AWS_ECR_CONTAINER_IMAGE =>
      val r = AWS_ECR_CONTAINER_IMAGE
      r
    case software.amazon.awssdk.services.inspector2.model.ResourceType.AWS_ECR_REPOSITORY =>
      val r = AWS_ECR_REPOSITORY
      r
    case software.amazon.awssdk.services.inspector2.model.ResourceType.AWS_LAMBDA_FUNCTION =>
      val r = AWS_LAMBDA_FUNCTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceType =
      software.amazon.awssdk.services.inspector2.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_EC2_INSTANCE extends zio.aws.inspector2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceType =
      software.amazon.awssdk.services.inspector2.model.ResourceType.AWS_EC2_INSTANCE
  }
  case object AWS_ECR_CONTAINER_IMAGE
      extends zio.aws.inspector2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceType =
      software.amazon.awssdk.services.inspector2.model.ResourceType.AWS_ECR_CONTAINER_IMAGE
  }
  case object AWS_ECR_REPOSITORY extends zio.aws.inspector2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceType =
      software.amazon.awssdk.services.inspector2.model.ResourceType.AWS_ECR_REPOSITORY
  }
  case object AWS_LAMBDA_FUNCTION
      extends zio.aws.inspector2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ResourceType =
      software.amazon.awssdk.services.inspector2.model.ResourceType.AWS_LAMBDA_FUNCTION
  }
}
