package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait SbomReportFormat {
  def unwrap: software.amazon.awssdk.services.inspector2.model.SbomReportFormat
}
object SbomReportFormat {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.SbomReportFormat
  ): zio.aws.inspector2.model.SbomReportFormat = value match {
    case software.amazon.awssdk.services.inspector2.model.SbomReportFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.SbomReportFormat.CYCLONEDX_1_4 =>
      val r = CYCLONEDX_1_4
      r
    case software.amazon.awssdk.services.inspector2.model.SbomReportFormat.SPDX_2_3 =>
      val r = SPDX_2_3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.SbomReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SbomReportFormat =
      software.amazon.awssdk.services.inspector2.model.SbomReportFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CYCLONEDX_1_4 extends zio.aws.inspector2.model.SbomReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SbomReportFormat =
      software.amazon.awssdk.services.inspector2.model.SbomReportFormat.CYCLONEDX_1_4
  }
  case object SPDX_2_3 extends zio.aws.inspector2.model.SbomReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SbomReportFormat =
      software.amazon.awssdk.services.inspector2.model.SbomReportFormat.SPDX_2_3
  }
}
