package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ScanMode {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ScanMode
}
object ScanMode {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ScanMode
  ): zio.aws.inspector2.model.ScanMode = value match {
    case software.amazon.awssdk.services.inspector2.model.ScanMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ScanMode.EC2_SSM_AGENT_BASED =>
      val r = EC2_SSM_AGENT_BASED
      r
    case software.amazon.awssdk.services.inspector2.model.ScanMode.EC2_AGENTLESS =>
      val r = EC2_AGENTLESS
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.ScanMode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanMode =
      software.amazon.awssdk.services.inspector2.model.ScanMode.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2_SSM_AGENT_BASED extends zio.aws.inspector2.model.ScanMode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanMode =
      software.amazon.awssdk.services.inspector2.model.ScanMode.EC2_SSM_AGENT_BASED
  }
  case object EC2_AGENTLESS extends zio.aws.inspector2.model.ScanMode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanMode =
      software.amazon.awssdk.services.inspector2.model.ScanMode.EC2_AGENTLESS
  }
}
