package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Schedule(
    daily: Optional[zio.aws.inspector2.model.DailySchedule] = Optional.Absent,
    monthly: Optional[zio.aws.inspector2.model.MonthlySchedule] =
      Optional.Absent,
    oneTime: Optional[zio.aws.inspector2.model.OneTimeSchedule] =
      Optional.Absent,
    weekly: Optional[zio.aws.inspector2.model.WeeklySchedule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Schedule = {
    import Schedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Schedule
      .builder()
      .optionallyWith(daily.map(value => value.buildAwsValue()))(_.daily)
      .optionallyWith(monthly.map(value => value.buildAwsValue()))(_.monthly)
      .optionallyWith(oneTime.map(value => value.buildAwsValue()))(_.oneTime)
      .optionallyWith(weekly.map(value => value.buildAwsValue()))(_.weekly)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Schedule.ReadOnly =
    zio.aws.inspector2.model.Schedule.wrap(buildAwsValue())
}
object Schedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Schedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Schedule =
      zio.aws.inspector2.model.Schedule(
        daily.map(value => value.asEditable),
        monthly.map(value => value.asEditable),
        oneTime.map(value => value.asEditable),
        weekly.map(value => value.asEditable)
      )
    def daily: Optional[zio.aws.inspector2.model.DailySchedule.ReadOnly]
    def monthly: Optional[zio.aws.inspector2.model.MonthlySchedule.ReadOnly]
    def oneTime: Optional[zio.aws.inspector2.model.OneTimeSchedule.ReadOnly]
    def weekly: Optional[zio.aws.inspector2.model.WeeklySchedule.ReadOnly]
    def getDaily
        : ZIO[Any, AwsError, zio.aws.inspector2.model.DailySchedule.ReadOnly] =
      AwsError.unwrapOptionField("daily", daily)
    def getMonthly: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.MonthlySchedule.ReadOnly
    ] = AwsError.unwrapOptionField("monthly", monthly)
    def getOneTime: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.OneTimeSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("oneTime", oneTime)
    def getWeekly
        : ZIO[Any, AwsError, zio.aws.inspector2.model.WeeklySchedule.ReadOnly] =
      AwsError.unwrapOptionField("weekly", weekly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Schedule
  ) extends zio.aws.inspector2.model.Schedule.ReadOnly {
    override val daily
        : Optional[zio.aws.inspector2.model.DailySchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.daily())
        .map(value => zio.aws.inspector2.model.DailySchedule.wrap(value))
    override val monthly
        : Optional[zio.aws.inspector2.model.MonthlySchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monthly())
        .map(value => zio.aws.inspector2.model.MonthlySchedule.wrap(value))
    override val oneTime
        : Optional[zio.aws.inspector2.model.OneTimeSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oneTime())
        .map(value => zio.aws.inspector2.model.OneTimeSchedule.wrap(value))
    override val weekly
        : Optional[zio.aws.inspector2.model.WeeklySchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weekly())
        .map(value => zio.aws.inspector2.model.WeeklySchedule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Schedule
  ): zio.aws.inspector2.model.Schedule.ReadOnly = new Wrapper(impl)
}
