package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class SearchVulnerabilitiesRequest(
    filterCriteria: zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest = {
    import SearchVulnerabilitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest
      .builder()
      .filterCriteria(filterCriteria.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.SearchVulnerabilitiesRequest.ReadOnly =
    zio.aws.inspector2.model.SearchVulnerabilitiesRequest.wrap(buildAwsValue())
}
object SearchVulnerabilitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.SearchVulnerabilitiesRequest =
      zio.aws.inspector2.model.SearchVulnerabilitiesRequest(
        filterCriteria.asEditable,
        nextToken.map(value => value)
      )
    def filterCriteria
        : zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria.ReadOnly
    def nextToken: Optional[NextToken]
    def getFilterCriteria: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria.ReadOnly
    ] = ZIO.succeed(filterCriteria)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest
  ) extends zio.aws.inspector2.model.SearchVulnerabilitiesRequest.ReadOnly {
    override val filterCriteria
        : zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria.ReadOnly =
      zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria
        .wrap(impl.filterCriteria())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest
  ): zio.aws.inspector2.model.SearchVulnerabilitiesRequest.ReadOnly =
    new Wrapper(impl)
}
