package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class SendCisSessionHealthRequest(
    scanJobId: UUID,
    sessionToken: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest = {
    import SendCisSessionHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest
      .builder()
      .scanJobId(UUID.unwrap(scanJobId): java.lang.String)
      .sessionToken(UUID.unwrap(sessionToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.SendCisSessionHealthRequest.ReadOnly =
    zio.aws.inspector2.model.SendCisSessionHealthRequest.wrap(buildAwsValue())
}
object SendCisSessionHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.SendCisSessionHealthRequest =
      zio.aws.inspector2.model
        .SendCisSessionHealthRequest(scanJobId, sessionToken)
    def scanJobId: UUID
    def sessionToken: UUID
    def getScanJobId: ZIO[Any, Nothing, UUID] = ZIO.succeed(scanJobId)
    def getSessionToken: ZIO[Any, Nothing, UUID] = ZIO.succeed(sessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest
  ) extends zio.aws.inspector2.model.SendCisSessionHealthRequest.ReadOnly {
    override val scanJobId: UUID =
      zio.aws.inspector2.model.primitives.UUID(impl.scanJobId())
    override val sessionToken: UUID =
      zio.aws.inspector2.model.primitives.UUID(impl.sessionToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest
  ): zio.aws.inspector2.model.SendCisSessionHealthRequest.ReadOnly =
    new Wrapper(impl)
}
