package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class SendCisSessionTelemetryRequest(
    messages: Iterable[zio.aws.inspector2.model.CisSessionMessage],
    scanJobId: UUID,
    sessionToken: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest = {
    import SendCisSessionTelemetryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest
      .builder()
      .messages(messages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .scanJobId(UUID.unwrap(scanJobId): java.lang.String)
      .sessionToken(UUID.unwrap(sessionToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.SendCisSessionTelemetryRequest.ReadOnly =
    zio.aws.inspector2.model.SendCisSessionTelemetryRequest
      .wrap(buildAwsValue())
}
object SendCisSessionTelemetryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.SendCisSessionTelemetryRequest =
      zio.aws.inspector2.model.SendCisSessionTelemetryRequest(
        messages.map { item =>
          item.asEditable
        },
        scanJobId,
        sessionToken
      )
    def messages: List[zio.aws.inspector2.model.CisSessionMessage.ReadOnly]
    def scanJobId: UUID
    def sessionToken: UUID
    def getMessages: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.CisSessionMessage.ReadOnly
    ]] = ZIO.succeed(messages)
    def getScanJobId: ZIO[Any, Nothing, UUID] = ZIO.succeed(scanJobId)
    def getSessionToken: ZIO[Any, Nothing, UUID] = ZIO.succeed(sessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest
  ) extends zio.aws.inspector2.model.SendCisSessionTelemetryRequest.ReadOnly {
    override val messages
        : List[zio.aws.inspector2.model.CisSessionMessage.ReadOnly] = impl
      .messages()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.CisSessionMessage.wrap(item)
      }
      .toList
    override val scanJobId: UUID =
      zio.aws.inspector2.model.primitives.UUID(impl.scanJobId())
    override val sessionToken: UUID =
      zio.aws.inspector2.model.primitives.UUID(impl.sessionToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest
  ): zio.aws.inspector2.model.SendCisSessionTelemetryRequest.ReadOnly =
    new Wrapper(impl)
}
