package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait Severity {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Severity
}
object Severity {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Severity
  ): zio.aws.inspector2.model.Severity = value match {
    case software.amazon.awssdk.services.inspector2.model.Severity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Severity.INFORMATIONAL =>
      val r = INFORMATIONAL
      r
    case software.amazon.awssdk.services.inspector2.model.Severity.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.inspector2.model.Severity.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.inspector2.model.Severity.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.Severity.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.Severity.UNTRIAGED =>
      val r = UNTRIAGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Severity =
      software.amazon.awssdk.services.inspector2.model.Severity.UNKNOWN_TO_SDK_VERSION
  }
  case object INFORMATIONAL extends zio.aws.inspector2.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Severity =
      software.amazon.awssdk.services.inspector2.model.Severity.INFORMATIONAL
  }
  case object LOW extends zio.aws.inspector2.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Severity =
      software.amazon.awssdk.services.inspector2.model.Severity.LOW
  }
  case object MEDIUM extends zio.aws.inspector2.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Severity =
      software.amazon.awssdk.services.inspector2.model.Severity.MEDIUM
  }
  case object HIGH extends zio.aws.inspector2.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Severity =
      software.amazon.awssdk.services.inspector2.model.Severity.HIGH
  }
  case object CRITICAL extends zio.aws.inspector2.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Severity =
      software.amazon.awssdk.services.inspector2.model.Severity.CRITICAL
  }
  case object UNTRIAGED extends zio.aws.inspector2.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Severity =
      software.amazon.awssdk.services.inspector2.model.Severity.UNTRIAGED
  }
}
