package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SortCriteria(
    field: zio.aws.inspector2.model.SortField,
    sortOrder: zio.aws.inspector2.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SortCriteria = {
    import SortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SortCriteria
      .builder()
      .field(field.unwrap)
      .sortOrder(sortOrder.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.SortCriteria.ReadOnly =
    zio.aws.inspector2.model.SortCriteria.wrap(buildAwsValue())
}
object SortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.SortCriteria =
      zio.aws.inspector2.model.SortCriteria(field, sortOrder)
    def field: zio.aws.inspector2.model.SortField
    def sortOrder: zio.aws.inspector2.model.SortOrder
    def getField: ZIO[Any, Nothing, zio.aws.inspector2.model.SortField] =
      ZIO.succeed(field)
    def getSortOrder: ZIO[Any, Nothing, zio.aws.inspector2.model.SortOrder] =
      ZIO.succeed(sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SortCriteria
  ) extends zio.aws.inspector2.model.SortCriteria.ReadOnly {
    override val field: zio.aws.inspector2.model.SortField =
      zio.aws.inspector2.model.SortField.wrap(impl.field())
    override val sortOrder: zio.aws.inspector2.model.SortOrder =
      zio.aws.inspector2.model.SortOrder.wrap(impl.sortOrder())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SortCriteria
  ): zio.aws.inspector2.model.SortCriteria.ReadOnly = new Wrapper(impl)
}
