package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.inspector2.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.SortOrder
  ): zio.aws.inspector2.model.SortOrder = value match {
    case software.amazon.awssdk.services.inspector2.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.SortOrder.ASC =>
      val r = ASC
      r
    case software.amazon.awssdk.services.inspector2.model.SortOrder.DESC =>
      val r = DESC
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortOrder =
      software.amazon.awssdk.services.inspector2.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASC extends zio.aws.inspector2.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortOrder =
      software.amazon.awssdk.services.inspector2.model.SortOrder.ASC
  }
  case object DESC extends zio.aws.inspector2.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.SortOrder =
      software.amazon.awssdk.services.inspector2.model.SortOrder.DESC
  }
}
