package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class StartCisSessionMessage(sessionToken: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.StartCisSessionMessage = {
    import StartCisSessionMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.StartCisSessionMessage
      .builder()
      .sessionToken(UUID.unwrap(sessionToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.StartCisSessionMessage.ReadOnly =
    zio.aws.inspector2.model.StartCisSessionMessage.wrap(buildAwsValue())
}
object StartCisSessionMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.StartCisSessionMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.StartCisSessionMessage =
      zio.aws.inspector2.model.StartCisSessionMessage(sessionToken)
    def sessionToken: UUID
    def getSessionToken: ZIO[Any, Nothing, UUID] = ZIO.succeed(sessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.StartCisSessionMessage
  ) extends zio.aws.inspector2.model.StartCisSessionMessage.ReadOnly {
    override val sessionToken: UUID =
      zio.aws.inspector2.model.primitives.UUID(impl.sessionToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.StartCisSessionMessage
  ): zio.aws.inspector2.model.StartCisSessionMessage.ReadOnly = new Wrapper(
    impl
  )
}
