package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class StartCisSessionRequest(
    message: zio.aws.inspector2.model.StartCisSessionMessage,
    scanJobId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest = {
    import StartCisSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest
      .builder()
      .message(message.buildAwsValue())
      .scanJobId(UUID.unwrap(scanJobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.StartCisSessionRequest.ReadOnly =
    zio.aws.inspector2.model.StartCisSessionRequest.wrap(buildAwsValue())
}
object StartCisSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.StartCisSessionRequest =
      zio.aws.inspector2.model
        .StartCisSessionRequest(message.asEditable, scanJobId)
    def message: zio.aws.inspector2.model.StartCisSessionMessage.ReadOnly
    def scanJobId: UUID
    def getMessage: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.StartCisSessionMessage.ReadOnly
    ] = ZIO.succeed(message)
    def getScanJobId: ZIO[Any, Nothing, UUID] = ZIO.succeed(scanJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest
  ) extends zio.aws.inspector2.model.StartCisSessionRequest.ReadOnly {
    override val message
        : zio.aws.inspector2.model.StartCisSessionMessage.ReadOnly =
      zio.aws.inspector2.model.StartCisSessionMessage.wrap(impl.message())
    override val scanJobId: UUID =
      zio.aws.inspector2.model.primitives.UUID(impl.scanJobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest
  ): zio.aws.inspector2.model.StartCisSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
