package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Status
  ): zio.aws.inspector2.model.Status = value match {
    case software.amazon.awssdk.services.inspector2.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Status.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.inspector2.model.Status.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.inspector2.model.Status.DISABLING =>
      val r = DISABLING
      r
    case software.amazon.awssdk.services.inspector2.model.Status.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.inspector2.model.Status.SUSPENDING =>
      val r = SUSPENDING
      r
    case software.amazon.awssdk.services.inspector2.model.Status.SUSPENDED =>
      val r = SUSPENDED
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Status =
      software.amazon.awssdk.services.inspector2.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLING extends zio.aws.inspector2.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Status =
      software.amazon.awssdk.services.inspector2.model.Status.ENABLING
  }
  case object ENABLED extends zio.aws.inspector2.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Status =
      software.amazon.awssdk.services.inspector2.model.Status.ENABLED
  }
  case object DISABLING extends zio.aws.inspector2.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Status =
      software.amazon.awssdk.services.inspector2.model.Status.DISABLING
  }
  case object DISABLED extends zio.aws.inspector2.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Status =
      software.amazon.awssdk.services.inspector2.model.Status.DISABLED
  }
  case object SUSPENDING extends zio.aws.inspector2.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Status =
      software.amazon.awssdk.services.inspector2.model.Status.SUSPENDING
  }
  case object SUSPENDED extends zio.aws.inspector2.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Status =
      software.amazon.awssdk.services.inspector2.model.Status.SUSPENDED
  }
}
