package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class StatusCounts(
    failed: Optional[Integer] = Optional.Absent,
    passed: Optional[Integer] = Optional.Absent,
    skipped: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.StatusCounts = {
    import StatusCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.StatusCounts
      .builder()
      .optionallyWith(failed.map(value => value: java.lang.Integer))(_.failed)
      .optionallyWith(passed.map(value => value: java.lang.Integer))(_.passed)
      .optionallyWith(skipped.map(value => value: java.lang.Integer))(_.skipped)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.StatusCounts.ReadOnly =
    zio.aws.inspector2.model.StatusCounts.wrap(buildAwsValue())
}
object StatusCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.StatusCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.StatusCounts =
      zio.aws.inspector2.model.StatusCounts(
        failed.map(value => value),
        passed.map(value => value),
        skipped.map(value => value)
      )
    def failed: Optional[Integer]
    def passed: Optional[Integer]
    def skipped: Optional[Integer]
    def getFailed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failed", failed)
    def getPassed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("passed", passed)
    def getSkipped: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("skipped", skipped)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.StatusCounts
  ) extends zio.aws.inspector2.model.StatusCounts.ReadOnly {
    override val failed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failed())
      .map(value => value: Integer)
    override val passed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.passed())
      .map(value => value: Integer)
    override val skipped: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.skipped())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.StatusCounts
  ): zio.aws.inspector2.model.StatusCounts.ReadOnly = new Wrapper(impl)
}
