package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.CheckCount
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StopCisMessageProgress(
    errorChecks: Optional[CheckCount] = Optional.Absent,
    failedChecks: Optional[CheckCount] = Optional.Absent,
    informationalChecks: Optional[CheckCount] = Optional.Absent,
    notApplicableChecks: Optional[CheckCount] = Optional.Absent,
    notEvaluatedChecks: Optional[CheckCount] = Optional.Absent,
    successfulChecks: Optional[CheckCount] = Optional.Absent,
    totalChecks: Optional[CheckCount] = Optional.Absent,
    unknownChecks: Optional[CheckCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.StopCisMessageProgress = {
    import StopCisMessageProgress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.StopCisMessageProgress
      .builder()
      .optionallyWith(
        errorChecks.map(value => CheckCount.unwrap(value): Integer)
      )(_.errorChecks)
      .optionallyWith(
        failedChecks.map(value => CheckCount.unwrap(value): Integer)
      )(_.failedChecks)
      .optionallyWith(
        informationalChecks.map(value => CheckCount.unwrap(value): Integer)
      )(_.informationalChecks)
      .optionallyWith(
        notApplicableChecks.map(value => CheckCount.unwrap(value): Integer)
      )(_.notApplicableChecks)
      .optionallyWith(
        notEvaluatedChecks.map(value => CheckCount.unwrap(value): Integer)
      )(_.notEvaluatedChecks)
      .optionallyWith(
        successfulChecks.map(value => CheckCount.unwrap(value): Integer)
      )(_.successfulChecks)
      .optionallyWith(
        totalChecks.map(value => CheckCount.unwrap(value): Integer)
      )(_.totalChecks)
      .optionallyWith(
        unknownChecks.map(value => CheckCount.unwrap(value): Integer)
      )(_.unknownChecks)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.StopCisMessageProgress.ReadOnly =
    zio.aws.inspector2.model.StopCisMessageProgress.wrap(buildAwsValue())
}
object StopCisMessageProgress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.StopCisMessageProgress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.StopCisMessageProgress =
      zio.aws.inspector2.model.StopCisMessageProgress(
        errorChecks.map(value => value),
        failedChecks.map(value => value),
        informationalChecks.map(value => value),
        notApplicableChecks.map(value => value),
        notEvaluatedChecks.map(value => value),
        successfulChecks.map(value => value),
        totalChecks.map(value => value),
        unknownChecks.map(value => value)
      )
    def errorChecks: Optional[CheckCount]
    def failedChecks: Optional[CheckCount]
    def informationalChecks: Optional[CheckCount]
    def notApplicableChecks: Optional[CheckCount]
    def notEvaluatedChecks: Optional[CheckCount]
    def successfulChecks: Optional[CheckCount]
    def totalChecks: Optional[CheckCount]
    def unknownChecks: Optional[CheckCount]
    def getErrorChecks: ZIO[Any, AwsError, CheckCount] =
      AwsError.unwrapOptionField("errorChecks", errorChecks)
    def getFailedChecks: ZIO[Any, AwsError, CheckCount] =
      AwsError.unwrapOptionField("failedChecks", failedChecks)
    def getInformationalChecks: ZIO[Any, AwsError, CheckCount] =
      AwsError.unwrapOptionField("informationalChecks", informationalChecks)
    def getNotApplicableChecks: ZIO[Any, AwsError, CheckCount] =
      AwsError.unwrapOptionField("notApplicableChecks", notApplicableChecks)
    def getNotEvaluatedChecks: ZIO[Any, AwsError, CheckCount] =
      AwsError.unwrapOptionField("notEvaluatedChecks", notEvaluatedChecks)
    def getSuccessfulChecks: ZIO[Any, AwsError, CheckCount] =
      AwsError.unwrapOptionField("successfulChecks", successfulChecks)
    def getTotalChecks: ZIO[Any, AwsError, CheckCount] =
      AwsError.unwrapOptionField("totalChecks", totalChecks)
    def getUnknownChecks: ZIO[Any, AwsError, CheckCount] =
      AwsError.unwrapOptionField("unknownChecks", unknownChecks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.StopCisMessageProgress
  ) extends zio.aws.inspector2.model.StopCisMessageProgress.ReadOnly {
    override val errorChecks: Optional[CheckCount] = zio.aws.core.internal
      .optionalFromNullable(impl.errorChecks())
      .map(value => zio.aws.inspector2.model.primitives.CheckCount(value))
    override val failedChecks: Optional[CheckCount] = zio.aws.core.internal
      .optionalFromNullable(impl.failedChecks())
      .map(value => zio.aws.inspector2.model.primitives.CheckCount(value))
    override val informationalChecks: Optional[CheckCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.informationalChecks())
        .map(value => zio.aws.inspector2.model.primitives.CheckCount(value))
    override val notApplicableChecks: Optional[CheckCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notApplicableChecks())
        .map(value => zio.aws.inspector2.model.primitives.CheckCount(value))
    override val notEvaluatedChecks: Optional[CheckCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notEvaluatedChecks())
        .map(value => zio.aws.inspector2.model.primitives.CheckCount(value))
    override val successfulChecks: Optional[CheckCount] = zio.aws.core.internal
      .optionalFromNullable(impl.successfulChecks())
      .map(value => zio.aws.inspector2.model.primitives.CheckCount(value))
    override val totalChecks: Optional[CheckCount] = zio.aws.core.internal
      .optionalFromNullable(impl.totalChecks())
      .map(value => zio.aws.inspector2.model.primitives.CheckCount(value))
    override val unknownChecks: Optional[CheckCount] = zio.aws.core.internal
      .optionalFromNullable(impl.unknownChecks())
      .map(value => zio.aws.inspector2.model.primitives.CheckCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.StopCisMessageProgress
  ): zio.aws.inspector2.model.StopCisMessageProgress.ReadOnly = new Wrapper(
    impl
  )
}
