package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  Reason,
  BenchmarkVersion,
  BenchmarkProfile
}
import scala.jdk.CollectionConverters.*
final case class StopCisSessionMessage(
    benchmarkProfile: Optional[BenchmarkProfile] = Optional.Absent,
    benchmarkVersion: Optional[BenchmarkVersion] = Optional.Absent,
    computePlatform: Optional[zio.aws.inspector2.model.ComputePlatform] =
      Optional.Absent,
    progress: zio.aws.inspector2.model.StopCisMessageProgress,
    reason: Optional[Reason] = Optional.Absent,
    status: zio.aws.inspector2.model.StopCisSessionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.StopCisSessionMessage = {
    import StopCisSessionMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.StopCisSessionMessage
      .builder()
      .optionallyWith(
        benchmarkProfile.map(value =>
          BenchmarkProfile.unwrap(value): java.lang.String
        )
      )(_.benchmarkProfile)
      .optionallyWith(
        benchmarkVersion.map(value =>
          BenchmarkVersion.unwrap(value): java.lang.String
        )
      )(_.benchmarkVersion)
      .optionallyWith(computePlatform.map(value => value.buildAwsValue()))(
        _.computePlatform
      )
      .progress(progress.buildAwsValue())
      .optionallyWith(
        reason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.reason)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.StopCisSessionMessage.ReadOnly =
    zio.aws.inspector2.model.StopCisSessionMessage.wrap(buildAwsValue())
}
object StopCisSessionMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.StopCisSessionMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.StopCisSessionMessage =
      zio.aws.inspector2.model.StopCisSessionMessage(
        benchmarkProfile.map(value => value),
        benchmarkVersion.map(value => value),
        computePlatform.map(value => value.asEditable),
        progress.asEditable,
        reason.map(value => value),
        status
      )
    def benchmarkProfile: Optional[BenchmarkProfile]
    def benchmarkVersion: Optional[BenchmarkVersion]
    def computePlatform
        : Optional[zio.aws.inspector2.model.ComputePlatform.ReadOnly]
    def progress: zio.aws.inspector2.model.StopCisMessageProgress.ReadOnly
    def reason: Optional[Reason]
    def status: zio.aws.inspector2.model.StopCisSessionStatus
    def getBenchmarkProfile: ZIO[Any, AwsError, BenchmarkProfile] =
      AwsError.unwrapOptionField("benchmarkProfile", benchmarkProfile)
    def getBenchmarkVersion: ZIO[Any, AwsError, BenchmarkVersion] =
      AwsError.unwrapOptionField("benchmarkVersion", benchmarkVersion)
    def getComputePlatform: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ComputePlatform.ReadOnly
    ] = AwsError.unwrapOptionField("computePlatform", computePlatform)
    def getProgress: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.StopCisMessageProgress.ReadOnly
    ] = ZIO.succeed(progress)
    def getReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("reason", reason)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.inspector2.model.StopCisSessionStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.StopCisSessionMessage
  ) extends zio.aws.inspector2.model.StopCisSessionMessage.ReadOnly {
    override val benchmarkProfile: Optional[BenchmarkProfile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.benchmarkProfile())
        .map(value =>
          zio.aws.inspector2.model.primitives.BenchmarkProfile(value)
        )
    override val benchmarkVersion: Optional[BenchmarkVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.benchmarkVersion())
        .map(value =>
          zio.aws.inspector2.model.primitives.BenchmarkVersion(value)
        )
    override val computePlatform
        : Optional[zio.aws.inspector2.model.ComputePlatform.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computePlatform())
        .map(value => zio.aws.inspector2.model.ComputePlatform.wrap(value))
    override val progress
        : zio.aws.inspector2.model.StopCisMessageProgress.ReadOnly =
      zio.aws.inspector2.model.StopCisMessageProgress.wrap(impl.progress())
    override val reason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.inspector2.model.primitives.Reason(value))
    override val status: zio.aws.inspector2.model.StopCisSessionStatus =
      zio.aws.inspector2.model.StopCisSessionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.StopCisSessionMessage
  ): zio.aws.inspector2.model.StopCisSessionMessage.ReadOnly = new Wrapper(impl)
}
