package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class StopCisSessionRequest(
    message: zio.aws.inspector2.model.StopCisSessionMessage,
    scanJobId: UUID,
    sessionToken: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest = {
    import StopCisSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest
      .builder()
      .message(message.buildAwsValue())
      .scanJobId(UUID.unwrap(scanJobId): java.lang.String)
      .sessionToken(UUID.unwrap(sessionToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.StopCisSessionRequest.ReadOnly =
    zio.aws.inspector2.model.StopCisSessionRequest.wrap(buildAwsValue())
}
object StopCisSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.StopCisSessionRequest =
      zio.aws.inspector2.model
        .StopCisSessionRequest(message.asEditable, scanJobId, sessionToken)
    def message: zio.aws.inspector2.model.StopCisSessionMessage.ReadOnly
    def scanJobId: UUID
    def sessionToken: UUID
    def getMessage: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.StopCisSessionMessage.ReadOnly
    ] = ZIO.succeed(message)
    def getScanJobId: ZIO[Any, Nothing, UUID] = ZIO.succeed(scanJobId)
    def getSessionToken: ZIO[Any, Nothing, UUID] = ZIO.succeed(sessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest
  ) extends zio.aws.inspector2.model.StopCisSessionRequest.ReadOnly {
    override val message
        : zio.aws.inspector2.model.StopCisSessionMessage.ReadOnly =
      zio.aws.inspector2.model.StopCisSessionMessage.wrap(impl.message())
    override val scanJobId: UUID =
      zio.aws.inspector2.model.primitives.UUID(impl.scanJobId())
    override val sessionToken: UUID =
      zio.aws.inspector2.model.primitives.UUID(impl.sessionToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest
  ): zio.aws.inspector2.model.StopCisSessionRequest.ReadOnly = new Wrapper(impl)
}
