package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait StopCisSessionStatus {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus
}
object StopCisSessionStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus
  ): zio.aws.inspector2.model.StopCisSessionStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.INTERRUPTED =>
      val r = INTERRUPTED
      r
    case software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.UNSUPPORTED_OS =>
      val r = UNSUPPORTED_OS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.StopCisSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus =
      software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.inspector2.model.StopCisSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus =
      software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.SUCCESS
  }
  case object FAILED extends zio.aws.inspector2.model.StopCisSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus =
      software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.FAILED
  }
  case object INTERRUPTED
      extends zio.aws.inspector2.model.StopCisSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus =
      software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.INTERRUPTED
  }
  case object UNSUPPORTED_OS
      extends zio.aws.inspector2.model.StopCisSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus =
      software.amazon.awssdk.services.inspector2.model.StopCisSessionStatus.UNSUPPORTED_OS
  }
}
