package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  SuggestedFixDescriptionString,
  SuggestedFixCodeString
}
import scala.jdk.CollectionConverters.*
final case class SuggestedFix(
    code: Optional[SuggestedFixCodeString] = Optional.Absent,
    description: Optional[SuggestedFixDescriptionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SuggestedFix = {
    import SuggestedFix.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SuggestedFix
      .builder()
      .optionallyWith(
        code.map(value =>
          SuggestedFixCodeString.unwrap(value): java.lang.String
        )
      )(_.code)
      .optionallyWith(
        description.map(value =>
          SuggestedFixDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.SuggestedFix.ReadOnly =
    zio.aws.inspector2.model.SuggestedFix.wrap(buildAwsValue())
}
object SuggestedFix {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SuggestedFix
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.SuggestedFix =
      zio.aws.inspector2.model
        .SuggestedFix(code.map(value => value), description.map(value => value))
    def code: Optional[SuggestedFixCodeString]
    def description: Optional[SuggestedFixDescriptionString]
    def getCode: ZIO[Any, AwsError, SuggestedFixCodeString] =
      AwsError.unwrapOptionField("code", code)
    def getDescription: ZIO[Any, AwsError, SuggestedFixDescriptionString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SuggestedFix
  ) extends zio.aws.inspector2.model.SuggestedFix.ReadOnly {
    override val code: Optional[SuggestedFixCodeString] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value =>
        zio.aws.inspector2.model.primitives.SuggestedFixCodeString(value)
      )
    override val description: Optional[SuggestedFixDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.inspector2.model.primitives
            .SuggestedFixDescriptionString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SuggestedFix
  ): zio.aws.inspector2.model.SuggestedFix.ReadOnly = new Wrapper(impl)
}
