package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait TagComparison {
  def unwrap: software.amazon.awssdk.services.inspector2.model.TagComparison
}
object TagComparison {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.TagComparison
  ): zio.aws.inspector2.model.TagComparison = value match {
    case software.amazon.awssdk.services.inspector2.model.TagComparison.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.TagComparison.EQUALS =>
      val r = EQUALS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.TagComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.TagComparison =
      software.amazon.awssdk.services.inspector2.model.TagComparison.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.inspector2.model.TagComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.TagComparison =
      software.amazon.awssdk.services.inspector2.model.TagComparison.EQUALS
  }
}
