package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class TagFilter(
    comparison: zio.aws.inspector2.model.TagComparison,
    key: NonEmptyString,
    value: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.TagFilter = {
    import TagFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.TagFilter
      .builder()
      .comparison(comparison.unwrap)
      .key(NonEmptyString.unwrap(key): java.lang.String)
      .value(NonEmptyString.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.TagFilter.ReadOnly =
    zio.aws.inspector2.model.TagFilter.wrap(buildAwsValue())
}
object TagFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.TagFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.TagFilter =
      zio.aws.inspector2.model.TagFilter(comparison, key, value)
    def comparison: zio.aws.inspector2.model.TagComparison
    def key: NonEmptyString
    def value: NonEmptyString
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.TagComparison] =
      ZIO.succeed(comparison)
    def getKey: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.TagFilter
  ) extends zio.aws.inspector2.model.TagFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.TagComparison =
      zio.aws.inspector2.model.TagComparison.wrap(impl.comparison())
    override val key: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.key())
    override val value: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.TagFilter
  ): zio.aws.inspector2.model.TagFilter.ReadOnly = new Wrapper(impl)
}
