package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{Timezone, TimeOfDay}
import scala.jdk.CollectionConverters.*
final case class Time(timeOfDay: TimeOfDay, timezone: Timezone) {
  def buildAwsValue(): software.amazon.awssdk.services.inspector2.model.Time = {
    import Time.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Time
      .builder()
      .timeOfDay(TimeOfDay.unwrap(timeOfDay): java.lang.String)
      .timezone(Timezone.unwrap(timezone): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Time.ReadOnly =
    zio.aws.inspector2.model.Time.wrap(buildAwsValue())
}
object Time {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Time] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Time =
      zio.aws.inspector2.model.Time(timeOfDay, timezone)
    def timeOfDay: TimeOfDay
    def timezone: Timezone
    def getTimeOfDay: ZIO[Any, Nothing, TimeOfDay] = ZIO.succeed(timeOfDay)
    def getTimezone: ZIO[Any, Nothing, Timezone] = ZIO.succeed(timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Time
  ) extends zio.aws.inspector2.model.Time.ReadOnly {
    override val timeOfDay: TimeOfDay =
      zio.aws.inspector2.model.primitives.TimeOfDay(impl.timeOfDay())
    override val timezone: Timezone =
      zio.aws.inspector2.model.primitives.Timezone(impl.timezone())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Time
  ): zio.aws.inspector2.model.Time.ReadOnly = new Wrapper(impl)
}
