package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{TagKey, Arn}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: Arn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UntagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UntagResourceRequest.ReadOnly =
    zio.aws.inspector2.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UntagResourceRequest =
      zio.aws.inspector2.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: Arn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UntagResourceRequest
  ) extends zio.aws.inspector2.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.inspector2.model.primitives.Arn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UntagResourceRequest
  ): zio.aws.inspector2.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
