package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  CisScanName,
  CisScanConfigurationArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateCisScanConfigurationRequest(
    scanConfigurationArn: CisScanConfigurationArn,
    scanName: Optional[CisScanName] = Optional.Absent,
    schedule: Optional[zio.aws.inspector2.model.Schedule] = Optional.Absent,
    securityLevel: Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      Optional.Absent,
    targets: Optional[zio.aws.inspector2.model.UpdateCisTargets] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest = {
    import UpdateCisScanConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest
      .builder()
      .scanConfigurationArn(
        CisScanConfigurationArn.unwrap(scanConfigurationArn): java.lang.String
      )
      .optionallyWith(
        scanName.map(value => CisScanName.unwrap(value): java.lang.String)
      )(_.scanName)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(securityLevel.map(value => value.unwrap))(_.securityLevel)
      .optionallyWith(targets.map(value => value.buildAwsValue()))(_.targets)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.UpdateCisScanConfigurationRequest.ReadOnly =
    zio.aws.inspector2.model.UpdateCisScanConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateCisScanConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UpdateCisScanConfigurationRequest =
      zio.aws.inspector2.model.UpdateCisScanConfigurationRequest(
        scanConfigurationArn,
        scanName.map(value => value),
        schedule.map(value => value.asEditable),
        securityLevel.map(value => value),
        targets.map(value => value.asEditable)
      )
    def scanConfigurationArn: CisScanConfigurationArn
    def scanName: Optional[CisScanName]
    def schedule: Optional[zio.aws.inspector2.model.Schedule.ReadOnly]
    def securityLevel: Optional[zio.aws.inspector2.model.CisSecurityLevel]
    def targets: Optional[zio.aws.inspector2.model.UpdateCisTargets.ReadOnly]
    def getScanConfigurationArn: ZIO[Any, Nothing, CisScanConfigurationArn] =
      ZIO.succeed(scanConfigurationArn)
    def getScanName: ZIO[Any, AwsError, CisScanName] =
      AwsError.unwrapOptionField("scanName", scanName)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getSecurityLevel
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSecurityLevel] =
      AwsError.unwrapOptionField("securityLevel", securityLevel)
    def getTargets: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.UpdateCisTargets.ReadOnly
    ] = AwsError.unwrapOptionField("targets", targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest
  ) extends zio.aws.inspector2.model.UpdateCisScanConfigurationRequest.ReadOnly {
    override val scanConfigurationArn: CisScanConfigurationArn =
      zio.aws.inspector2.model.primitives
        .CisScanConfigurationArn(impl.scanConfigurationArn())
    override val scanName: Optional[CisScanName] = zio.aws.core.internal
      .optionalFromNullable(impl.scanName())
      .map(value => zio.aws.inspector2.model.primitives.CisScanName(value))
    override val schedule
        : Optional[zio.aws.inspector2.model.Schedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.inspector2.model.Schedule.wrap(value))
    override val securityLevel
        : Optional[zio.aws.inspector2.model.CisSecurityLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityLevel())
        .map(value => zio.aws.inspector2.model.CisSecurityLevel.wrap(value))
    override val targets
        : Optional[zio.aws.inspector2.model.UpdateCisTargets.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value => zio.aws.inspector2.model.UpdateCisTargets.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest
  ): zio.aws.inspector2.model.UpdateCisScanConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
