package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  TargetResourceTagsValue,
  TargetResourceTagsKey,
  TargetAccount
}
import scala.jdk.CollectionConverters.*
final case class UpdateCisTargets(
    accountIds: Optional[Iterable[TargetAccount]] = Optional.Absent,
    targetResourceTags: Optional[
      Map[TargetResourceTagsKey, Iterable[TargetResourceTagsValue]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateCisTargets = {
    import UpdateCisTargets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateCisTargets
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            TargetAccount.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        targetResourceTags.map(value =>
          value
            .map({ case (key, value) =>
              (TargetResourceTagsKey
                .unwrap(key): java.lang.String) -> value.map { item =>
                TargetResourceTagsValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.targetResourceTags)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UpdateCisTargets.ReadOnly =
    zio.aws.inspector2.model.UpdateCisTargets.wrap(buildAwsValue())
}
object UpdateCisTargets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateCisTargets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UpdateCisTargets =
      zio.aws.inspector2.model.UpdateCisTargets(
        accountIds.map(value => value),
        targetResourceTags.map(value => value)
      )
    def accountIds: Optional[List[TargetAccount]]
    def targetResourceTags
        : Optional[Map[TargetResourceTagsKey, List[TargetResourceTagsValue]]]
    def getAccountIds: ZIO[Any, AwsError, List[TargetAccount]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getTargetResourceTags
        : ZIO[Any, AwsError, Map[TargetResourceTagsKey, List[
          TargetResourceTagsValue
        ]]] =
      AwsError.unwrapOptionField("targetResourceTags", targetResourceTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateCisTargets
  ) extends zio.aws.inspector2.model.UpdateCisTargets.ReadOnly {
    override val accountIds: Optional[List[TargetAccount]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.TargetAccount(item)
          }.toList
        )
    override val targetResourceTags
        : Optional[Map[TargetResourceTagsKey, List[TargetResourceTagsValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResourceTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.inspector2.model.primitives
                .TargetResourceTagsKey(key) -> value.asScala.map { item =>
                zio.aws.inspector2.model.primitives
                  .TargetResourceTagsValue(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateCisTargets
  ): zio.aws.inspector2.model.UpdateCisTargets.ReadOnly = new Wrapper(impl)
}
