package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationRequest(
    ec2Configuration: Optional[zio.aws.inspector2.model.Ec2Configuration] =
      Optional.Absent,
    ecrConfiguration: Optional[zio.aws.inspector2.model.EcrConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest = {
    import UpdateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest
      .builder()
      .optionallyWith(ec2Configuration.map(value => value.buildAwsValue()))(
        _.ec2Configuration
      )
      .optionallyWith(ecrConfiguration.map(value => value.buildAwsValue()))(
        _.ecrConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UpdateConfigurationRequest.ReadOnly =
    zio.aws.inspector2.model.UpdateConfigurationRequest.wrap(buildAwsValue())
}
object UpdateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UpdateConfigurationRequest =
      zio.aws.inspector2.model.UpdateConfigurationRequest(
        ec2Configuration.map(value => value.asEditable),
        ecrConfiguration.map(value => value.asEditable)
      )
    def ec2Configuration
        : Optional[zio.aws.inspector2.model.Ec2Configuration.ReadOnly]
    def ecrConfiguration
        : Optional[zio.aws.inspector2.model.EcrConfiguration.ReadOnly]
    def getEc2Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.Ec2Configuration.ReadOnly
    ] = AwsError.unwrapOptionField("ec2Configuration", ec2Configuration)
    def getEcrConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ecrConfiguration", ecrConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest
  ) extends zio.aws.inspector2.model.UpdateConfigurationRequest.ReadOnly {
    override val ec2Configuration
        : Optional[zio.aws.inspector2.model.Ec2Configuration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2Configuration())
        .map(value => zio.aws.inspector2.model.Ec2Configuration.wrap(value))
    override val ecrConfiguration
        : Optional[zio.aws.inspector2.model.EcrConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrConfiguration())
        .map(value => zio.aws.inspector2.model.EcrConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest
  ): zio.aws.inspector2.model.UpdateConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
