package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.Path
import scala.jdk.CollectionConverters.*
final case class UpdateEc2DeepInspectionConfigurationRequest(
    activateDeepInspection: Optional[Boolean] = Optional.Absent,
    packagePaths: Optional[Iterable[Path]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest = {
    import UpdateEc2DeepInspectionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest
      .builder()
      .optionallyWith(
        activateDeepInspection.map(value => value: java.lang.Boolean)
      )(_.activateDeepInspection)
      .optionallyWith(
        packagePaths.map(value =>
          value.map { item =>
            Path.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.packagePaths)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest.ReadOnly =
    zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateEc2DeepInspectionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest =
      zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest(
        activateDeepInspection.map(value => value),
        packagePaths.map(value => value)
      )
    def activateDeepInspection: Optional[Boolean]
    def packagePaths: Optional[List[Path]]
    def getActivateDeepInspection: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("activateDeepInspection", activateDeepInspection)
    def getPackagePaths: ZIO[Any, AwsError, List[Path]] =
      AwsError.unwrapOptionField("packagePaths", packagePaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest
  ) extends zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest.ReadOnly {
    override val activateDeepInspection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activateDeepInspection())
        .map(value => value: Boolean)
    override val packagePaths: Optional[List[Path]] = zio.aws.core.internal
      .optionalFromNullable(impl.packagePaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Path(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest
  ): zio.aws.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
