package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class WeeklySchedule(
    days: Iterable[zio.aws.inspector2.model.Day],
    startTime: zio.aws.inspector2.model.Time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.WeeklySchedule = {
    import WeeklySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.WeeklySchedule
      .builder()
      .daysWithStrings(days.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .startTime(startTime.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.WeeklySchedule.ReadOnly =
    zio.aws.inspector2.model.WeeklySchedule.wrap(buildAwsValue())
}
object WeeklySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.WeeklySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.WeeklySchedule =
      zio.aws.inspector2.model.WeeklySchedule(days, startTime.asEditable)
    def days: List[zio.aws.inspector2.model.Day]
    def startTime: zio.aws.inspector2.model.Time.ReadOnly
    def getDays: ZIO[Any, Nothing, List[zio.aws.inspector2.model.Day]] =
      ZIO.succeed(days)
    def getStartTime
        : ZIO[Any, Nothing, zio.aws.inspector2.model.Time.ReadOnly] =
      ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.WeeklySchedule
  ) extends zio.aws.inspector2.model.WeeklySchedule.ReadOnly {
    override val days: List[zio.aws.inspector2.model.Day] = impl
      .days()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.Day.wrap(item)
      }
      .toList
    override val startTime: zio.aws.inspector2.model.Time.ReadOnly =
      zio.aws.inspector2.model.Time.wrap(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.WeeklySchedule
  ): zio.aws.inspector2.model.WeeklySchedule.ReadOnly = new Wrapper(impl)
}
