package zio.aws.inspector2
import zio.aws.inspector2.model.primitives.Timestamp.Type
import zio.aws.inspector2.model.primitives.{
  SubnetId,
  Tool,
  TargetResourceTagsKey,
  MapKey,
  LambdaLayerArn,
  SecurityGroupId,
  IpV6Address,
  UsageAccountId,
  AccountId,
  Cwe,
  VulnerabilityReferenceUrl,
  VulnId,
  FindingArn,
  TargetResourceTagsValue,
  MapValue,
  RelatedVulnerability,
  VulnerabilityId,
  Path,
  MeteringAccountId,
  FilterArn,
  IpV4Address,
  Target,
  NonEmptyString,
  TargetAccount,
  TagKey,
  Ttp
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends zio.prelude.Subtype[String]
    type AccountId = zio.aws.inspector2.model.primitives.AccountId.Type
    object AggCounts extends zio.prelude.Subtype[Long]
    type AggCounts = zio.aws.inspector2.model.primitives.AggCounts.Type
    object AmiId extends zio.prelude.Subtype[String]
    type AmiId = zio.aws.inspector2.model.primitives.AmiId.Type
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.inspector2.model.primitives.Arn.Type
    object BenchmarkProfile extends zio.prelude.Subtype[String]
    type BenchmarkProfile =
      zio.aws.inspector2.model.primitives.BenchmarkProfile.Type
    object BenchmarkVersion extends zio.prelude.Subtype[String]
    type BenchmarkVersion =
      zio.aws.inspector2.model.primitives.BenchmarkVersion.Type
    object CheckCount extends zio.prelude.Subtype[Int]
    type CheckCount = zio.aws.inspector2.model.primitives.CheckCount.Type
    object CisFindingArn extends zio.prelude.Subtype[String]
    type CisFindingArn = zio.aws.inspector2.model.primitives.CisFindingArn.Type
    object CisOwnerId extends zio.prelude.Subtype[String]
    type CisOwnerId = zio.aws.inspector2.model.primitives.CisOwnerId.Type
    object CisRuleDetails extends zio.prelude.Subtype[Chunk[Byte]]
    type CisRuleDetails =
      zio.aws.inspector2.model.primitives.CisRuleDetails.Type
    object CisScanArn extends zio.prelude.Subtype[String]
    type CisScanArn = zio.aws.inspector2.model.primitives.CisScanArn.Type
    object CisScanConfigurationArn extends zio.prelude.Subtype[String]
    type CisScanConfigurationArn =
      zio.aws.inspector2.model.primitives.CisScanConfigurationArn.Type
    object CisScanName extends zio.prelude.Subtype[String]
    type CisScanName = zio.aws.inspector2.model.primitives.CisScanName.Type
    object CisScanResultsMaxResults extends zio.prelude.Subtype[Int]
    type CisScanResultsMaxResults =
      zio.aws.inspector2.model.primitives.CisScanResultsMaxResults.Type
    object CisaAction extends zio.prelude.Subtype[String]
    type CisaAction = zio.aws.inspector2.model.primitives.CisaAction.Type
    object CisaDateAdded extends zio.prelude.Subtype[Instant]
    type CisaDateAdded = zio.aws.inspector2.model.primitives.CisaDateAdded.Type
    object CisaDateDue extends zio.prelude.Subtype[Instant]
    type CisaDateDue = zio.aws.inspector2.model.primitives.CisaDateDue.Type
    object ClientToken extends zio.prelude.Subtype[String]
    type ClientToken = zio.aws.inspector2.model.primitives.ClientToken.Type
    object CodeLineContentString extends zio.prelude.Subtype[String]
    type CodeLineContentString =
      zio.aws.inspector2.model.primitives.CodeLineContentString.Type
    object Component extends zio.prelude.Subtype[String]
    type Component = zio.aws.inspector2.model.primitives.Component.Type
    object ComponentType extends zio.prelude.Subtype[String]
    type ComponentType = zio.aws.inspector2.model.primitives.ComponentType.Type
    object CoverageStringInput extends zio.prelude.Subtype[String]
    type CoverageStringInput =
      zio.aws.inspector2.model.primitives.CoverageStringInput.Type
    object Cvss2BaseScore extends zio.prelude.Subtype[Double]
    type Cvss2BaseScore =
      zio.aws.inspector2.model.primitives.Cvss2BaseScore.Type
    object Cvss2ScoringVector extends zio.prelude.Subtype[String]
    type Cvss2ScoringVector =
      zio.aws.inspector2.model.primitives.Cvss2ScoringVector.Type
    object Cvss3BaseScore extends zio.prelude.Subtype[Double]
    type Cvss3BaseScore =
      zio.aws.inspector2.model.primitives.Cvss3BaseScore.Type
    object Cvss3ScoringVector extends zio.prelude.Subtype[String]
    type Cvss3ScoringVector =
      zio.aws.inspector2.model.primitives.Cvss3ScoringVector.Type
    object Cwe extends zio.prelude.Subtype[String]
    type Cwe = zio.aws.inspector2.model.primitives.Cwe.Type
    object DateTimeTimestamp extends zio.prelude.Subtype[Instant]
    type DateTimeTimestamp =
      zio.aws.inspector2.model.primitives.DateTimeTimestamp.Type
    object EpssScore extends zio.prelude.Subtype[Double]
    type EpssScore = zio.aws.inspector2.model.primitives.EpssScore.Type
    object EpssScoreValue extends zio.prelude.Subtype[Double]
    type EpssScoreValue =
      zio.aws.inspector2.model.primitives.EpssScoreValue.Type
    object ErrorMessage extends zio.prelude.Subtype[String]
    type ErrorMessage = zio.aws.inspector2.model.primitives.ErrorMessage.Type
    object EvidenceDetail extends zio.prelude.Subtype[String]
    type EvidenceDetail =
      zio.aws.inspector2.model.primitives.EvidenceDetail.Type
    object EvidenceRule extends zio.prelude.Subtype[String]
    type EvidenceRule = zio.aws.inspector2.model.primitives.EvidenceRule.Type
    object EvidenceSeverity extends zio.prelude.Subtype[String]
    type EvidenceSeverity =
      zio.aws.inspector2.model.primitives.EvidenceSeverity.Type
    object ExecutionRoleArn extends zio.prelude.Subtype[String]
    type ExecutionRoleArn =
      zio.aws.inspector2.model.primitives.ExecutionRoleArn.Type
    object FilePath extends zio.prelude.Subtype[String]
    type FilePath = zio.aws.inspector2.model.primitives.FilePath.Type
    object FilterArn extends zio.prelude.Subtype[String]
    type FilterArn = zio.aws.inspector2.model.primitives.FilterArn.Type
    object FilterDescription extends zio.prelude.Subtype[String]
    type FilterDescription =
      zio.aws.inspector2.model.primitives.FilterDescription.Type
    object FilterName extends zio.prelude.Subtype[String]
    type FilterName = zio.aws.inspector2.model.primitives.FilterName.Type
    object FilterReason extends zio.prelude.Subtype[String]
    type FilterReason = zio.aws.inspector2.model.primitives.FilterReason.Type
    object FindingArn extends zio.prelude.Subtype[String]
    type FindingArn = zio.aws.inspector2.model.primitives.FindingArn.Type
    object FindingDescription extends zio.prelude.Subtype[String]
    type FindingDescription =
      zio.aws.inspector2.model.primitives.FindingDescription.Type
    object FindingTitle extends zio.prelude.Subtype[String]
    type FindingTitle = zio.aws.inspector2.model.primitives.FindingTitle.Type
    object FirstSeen extends zio.prelude.Subtype[Instant]
    type FirstSeen = zio.aws.inspector2.model.primitives.FirstSeen.Type
    object FunctionName extends zio.prelude.Subtype[String]
    type FunctionName = zio.aws.inspector2.model.primitives.FunctionName.Type
    object GetCisScanResultDetailsMaxResults extends zio.prelude.Subtype[Int]
    type GetCisScanResultDetailsMaxResults =
      zio.aws.inspector2.model.primitives.GetCisScanResultDetailsMaxResults.Type
    object ImageHash extends zio.prelude.Subtype[String]
    type ImageHash = zio.aws.inspector2.model.primitives.ImageHash.Type
    type Integer = Int
    object IpV4Address extends zio.prelude.Subtype[String]
    type IpV4Address = zio.aws.inspector2.model.primitives.IpV4Address.Type
    object IpV6Address extends zio.prelude.Subtype[String]
    type IpV6Address = zio.aws.inspector2.model.primitives.IpV6Address.Type
    object KmsKeyArn extends zio.prelude.Subtype[String]
    type KmsKeyArn = zio.aws.inspector2.model.primitives.KmsKeyArn.Type
    object LambdaLayerArn extends zio.prelude.Subtype[String]
    type LambdaLayerArn =
      zio.aws.inspector2.model.primitives.LambdaLayerArn.Type
    object LastSeen extends zio.prelude.Subtype[Instant]
    type LastSeen = zio.aws.inspector2.model.primitives.LastSeen.Type
    object ListAccountPermissionsMaxResults extends zio.prelude.Subtype[Int]
    type ListAccountPermissionsMaxResults =
      zio.aws.inspector2.model.primitives.ListAccountPermissionsMaxResults.Type
    object ListCisScanConfigurationsMaxResults extends zio.prelude.Subtype[Int]
    type ListCisScanConfigurationsMaxResults =
      zio.aws.inspector2.model.primitives.ListCisScanConfigurationsMaxResults.Type
    object ListCisScansMaxResults extends zio.prelude.Subtype[Int]
    type ListCisScansMaxResults =
      zio.aws.inspector2.model.primitives.ListCisScansMaxResults.Type
    object ListCoverageMaxResults extends zio.prelude.Subtype[Int]
    type ListCoverageMaxResults =
      zio.aws.inspector2.model.primitives.ListCoverageMaxResults.Type
    object ListDelegatedAdminMaxResults extends zio.prelude.Subtype[Int]
    type ListDelegatedAdminMaxResults =
      zio.aws.inspector2.model.primitives.ListDelegatedAdminMaxResults.Type
    object ListFilterMaxResults extends zio.prelude.Subtype[Int]
    type ListFilterMaxResults =
      zio.aws.inspector2.model.primitives.ListFilterMaxResults.Type
    object ListFindingAggregationsMaxResults extends zio.prelude.Subtype[Int]
    type ListFindingAggregationsMaxResults =
      zio.aws.inspector2.model.primitives.ListFindingAggregationsMaxResults.Type
    object ListFindingsMaxResults extends zio.prelude.Subtype[Int]
    type ListFindingsMaxResults =
      zio.aws.inspector2.model.primitives.ListFindingsMaxResults.Type
    object ListMembersMaxResults extends zio.prelude.Subtype[Int]
    type ListMembersMaxResults =
      zio.aws.inspector2.model.primitives.ListMembersMaxResults.Type
    object ListUsageTotalsMaxResults extends zio.prelude.Subtype[Int]
    type ListUsageTotalsMaxResults =
      zio.aws.inspector2.model.primitives.ListUsageTotalsMaxResults.Type
    object ListUsageTotalsNextToken extends zio.prelude.Subtype[String]
    type ListUsageTotalsNextToken =
      zio.aws.inspector2.model.primitives.ListUsageTotalsNextToken.Type
    object MapKey extends zio.prelude.Subtype[String]
    type MapKey = zio.aws.inspector2.model.primitives.MapKey.Type
    object MapValue extends zio.prelude.Subtype[String]
    type MapValue = zio.aws.inspector2.model.primitives.MapValue.Type
    object MeteringAccountId extends zio.prelude.Subtype[String]
    type MeteringAccountId =
      zio.aws.inspector2.model.primitives.MeteringAccountId.Type
    object MonthlyCostEstimate extends zio.prelude.Subtype[Double]
    type MonthlyCostEstimate =
      zio.aws.inspector2.model.primitives.MonthlyCostEstimate.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.inspector2.model.primitives.NextToken.Type
    object NonEmptyString extends zio.prelude.Subtype[String]
    type NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString.Type
    object OwnerId extends zio.prelude.Subtype[String]
    type OwnerId = zio.aws.inspector2.model.primitives.OwnerId.Type
    object PackageArchitecture extends zio.prelude.Subtype[String]
    type PackageArchitecture =
      zio.aws.inspector2.model.primitives.PackageArchitecture.Type
    object PackageEpoch extends zio.prelude.Subtype[Int]
    type PackageEpoch = zio.aws.inspector2.model.primitives.PackageEpoch.Type
    object PackageName extends zio.prelude.Subtype[String]
    type PackageName = zio.aws.inspector2.model.primitives.PackageName.Type
    object PackageRelease extends zio.prelude.Subtype[String]
    type PackageRelease =
      zio.aws.inspector2.model.primitives.PackageRelease.Type
    object PackageVersion extends zio.prelude.Subtype[String]
    type PackageVersion =
      zio.aws.inspector2.model.primitives.PackageVersion.Type
    object Path extends zio.prelude.Subtype[String]
    type Path = zio.aws.inspector2.model.primitives.Path.Type
    object Platform extends zio.prelude.Subtype[String]
    type Platform = zio.aws.inspector2.model.primitives.Platform.Type
    object PlatformVersion extends zio.prelude.Subtype[String]
    type PlatformVersion =
      zio.aws.inspector2.model.primitives.PlatformVersion.Type
    object Port extends zio.prelude.Subtype[Int]
    type Port = zio.aws.inspector2.model.primitives.Port.Type
    object Product extends zio.prelude.Subtype[String]
    type Product = zio.aws.inspector2.model.primitives.Product.Type
    object Reason extends zio.prelude.Subtype[String]
    type Reason = zio.aws.inspector2.model.primitives.Reason.Type
    object RelatedVulnerability extends zio.prelude.Subtype[String]
    type RelatedVulnerability =
      zio.aws.inspector2.model.primitives.RelatedVulnerability.Type
    object ReportId extends zio.prelude.Subtype[String]
    type ReportId = zio.aws.inspector2.model.primitives.ReportId.Type
    object ResourceId extends zio.prelude.Subtype[String]
    type ResourceId = zio.aws.inspector2.model.primitives.ResourceId.Type
    object ResourceStringInput extends zio.prelude.Subtype[String]
    type ResourceStringInput =
      zio.aws.inspector2.model.primitives.ResourceStringInput.Type
    object RiskScore extends zio.prelude.Subtype[Int]
    type RiskScore = zio.aws.inspector2.model.primitives.RiskScore.Type
    object RuleId extends zio.prelude.Subtype[String]
    type RuleId = zio.aws.inspector2.model.primitives.RuleId.Type
    object SecurityGroupId extends zio.prelude.Subtype[String]
    type SecurityGroupId =
      zio.aws.inspector2.model.primitives.SecurityGroupId.Type
    object SourceLayerHash extends zio.prelude.Subtype[String]
    type SourceLayerHash =
      zio.aws.inspector2.model.primitives.SourceLayerHash.Type
    object StringInput extends zio.prelude.Subtype[String]
    type StringInput = zio.aws.inspector2.model.primitives.StringInput.Type
    object SubnetId extends zio.prelude.Subtype[String]
    type SubnetId = zio.aws.inspector2.model.primitives.SubnetId.Type
    object SuggestedFixCodeString extends zio.prelude.Subtype[String]
    type SuggestedFixCodeString =
      zio.aws.inspector2.model.primitives.SuggestedFixCodeString.Type
    object SuggestedFixDescriptionString extends zio.prelude.Subtype[String]
    type SuggestedFixDescriptionString =
      zio.aws.inspector2.model.primitives.SuggestedFixDescriptionString.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.inspector2.model.primitives.TagKey.Type
    object Target extends zio.prelude.Subtype[String]
    type Target = zio.aws.inspector2.model.primitives.Target.Type
    object TargetAccount extends zio.prelude.Subtype[String]
    type TargetAccount = zio.aws.inspector2.model.primitives.TargetAccount.Type
    object TargetResourceTagsKey extends zio.prelude.Subtype[String]
    type TargetResourceTagsKey =
      zio.aws.inspector2.model.primitives.TargetResourceTagsKey.Type
    object TargetResourceTagsValue extends zio.prelude.Subtype[String]
    type TargetResourceTagsValue =
      zio.aws.inspector2.model.primitives.TargetResourceTagsValue.Type
    object TimeOfDay extends zio.prelude.Subtype[String]
    type TimeOfDay = zio.aws.inspector2.model.primitives.TimeOfDay.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.inspector2.model.primitives.Timestamp.Type
    object Timezone extends zio.prelude.Subtype[String]
    type Timezone = zio.aws.inspector2.model.primitives.Timezone.Type
    object Tool extends zio.prelude.Subtype[String]
    type Tool = zio.aws.inspector2.model.primitives.Tool.Type
    object Ttp extends zio.prelude.Subtype[String]
    type Ttp = zio.aws.inspector2.model.primitives.Ttp.Type
    object UUID extends zio.prelude.Subtype[String]
    type UUID = zio.aws.inspector2.model.primitives.UUID.Type
    object UsageAccountId extends zio.prelude.Subtype[String]
    type UsageAccountId =
      zio.aws.inspector2.model.primitives.UsageAccountId.Type
    object UsageValue extends zio.prelude.Subtype[Double]
    type UsageValue = zio.aws.inspector2.model.primitives.UsageValue.Type
    object Vendor extends zio.prelude.Subtype[String]
    type Vendor = zio.aws.inspector2.model.primitives.Vendor.Type
    object VendorCreatedAt extends zio.prelude.Subtype[Instant]
    type VendorCreatedAt =
      zio.aws.inspector2.model.primitives.VendorCreatedAt.Type
    object VendorSeverity extends zio.prelude.Subtype[String]
    type VendorSeverity =
      zio.aws.inspector2.model.primitives.VendorSeverity.Type
    object VendorUpdatedAt extends zio.prelude.Subtype[Instant]
    type VendorUpdatedAt =
      zio.aws.inspector2.model.primitives.VendorUpdatedAt.Type
    object Version extends zio.prelude.Subtype[String]
    type Version = zio.aws.inspector2.model.primitives.Version.Type
    object VpcId extends zio.prelude.Subtype[String]
    type VpcId = zio.aws.inspector2.model.primitives.VpcId.Type
    object VulnId extends zio.prelude.Subtype[String]
    type VulnId = zio.aws.inspector2.model.primitives.VulnId.Type
    object VulnerabilityDescription extends zio.prelude.Subtype[String]
    type VulnerabilityDescription =
      zio.aws.inspector2.model.primitives.VulnerabilityDescription.Type
    object VulnerabilityId extends zio.prelude.Subtype[String]
    type VulnerabilityId =
      zio.aws.inspector2.model.primitives.VulnerabilityId.Type
    object VulnerabilityReferenceUrl extends zio.prelude.Subtype[String]
    type VulnerabilityReferenceUrl =
      zio.aws.inspector2.model.primitives.VulnerabilityReferenceUrl.Type
    object VulnerabilitySourceUrl extends zio.prelude.Subtype[String]
    type VulnerabilitySourceUrl =
      zio.aws.inspector2.model.primitives.VulnerabilitySourceUrl.Type
    object VulnerablePackageRemediation extends zio.prelude.Subtype[String]
    type VulnerablePackageRemediation =
      zio.aws.inspector2.model.primitives.VulnerablePackageRemediation.Type
  }
  type AccountIdFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type AccountIdSet = List[AccountId]
  type AccountList = List[zio.aws.inspector2.model.Account]
  type AccountStateList = List[zio.aws.inspector2.model.AccountState]
  type AggregationResponseList =
    List[zio.aws.inspector2.model.AggregationResponse]
  type ArchitectureList = List[zio.aws.inspector2.model.Architecture]
  type BatchGetCodeSnippetRequestFindingArnsList = List[FindingArn]
  type BatchGetFreeTrialInfoRequestAccountIdsList = List[MeteringAccountId]
  type CheckIdFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type CisAccountIdList = List[AccountId]
  type CisCheckAggregationList =
    List[zio.aws.inspector2.model.CisCheckAggregation]
  type CisFindingArnFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type CisFindingStatusFilterList =
    List[zio.aws.inspector2.model.CisFindingStatusFilter]
  type CisNumberFilterList = List[zio.aws.inspector2.model.CisNumberFilter]
  type CisResultStatusFilterList =
    List[zio.aws.inspector2.model.CisResultStatusFilter]
  type CisScanArnFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type CisScanConfigurationArnFilterList =
    List[zio.aws.inspector2.model.CisStringFilter]
  type CisScanConfigurationList =
    List[zio.aws.inspector2.model.CisScanConfiguration]
  type CisScanDateFilterList = List[zio.aws.inspector2.model.CisDateFilter]
  type CisScanList = List[zio.aws.inspector2.model.CisScan]
  type CisScanNameFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type CisScanResultDetailsList =
    List[zio.aws.inspector2.model.CisScanResultDetails]
  type CisScanStatusFilterList =
    List[zio.aws.inspector2.model.CisScanStatusFilter]
  type CisScheduledByFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type CisSecurityLevelFilterList =
    List[zio.aws.inspector2.model.CisSecurityLevelFilter]
  type CisSessionMessages = List[zio.aws.inspector2.model.CisSessionMessage]
  type CisTagMap = Map[MapKey, MapValue]
  type CisTargetResourceAggregationList =
    List[zio.aws.inspector2.model.CisTargetResourceAggregation]
  type CodeLineList = List[zio.aws.inspector2.model.CodeLine]
  type CodeSnippetErrorList = List[zio.aws.inspector2.model.CodeSnippetError]
  type CodeSnippetResultList = List[zio.aws.inspector2.model.CodeSnippetResult]
  type CountsList = List[zio.aws.inspector2.model.Counts]
  type CoverageDateFilterList =
    List[zio.aws.inspector2.model.CoverageDateFilter]
  type CoverageMapFilterList = List[zio.aws.inspector2.model.CoverageMapFilter]
  type CoverageStringFilterList =
    List[zio.aws.inspector2.model.CoverageStringFilter]
  type CoveredResources = List[zio.aws.inspector2.model.CoveredResource]
  type CvssScoreAdjustmentList =
    List[zio.aws.inspector2.model.CvssScoreAdjustment]
  type CvssScoreList = List[zio.aws.inspector2.model.CvssScore]
  type CweList = List[NonEmptyString]
  type Cwes = List[Cwe]
  type DateFilterList = List[zio.aws.inspector2.model.DateFilter]
  type DaysList = List[zio.aws.inspector2.model.Day]
  type DelegatedAdminAccountList =
    List[zio.aws.inspector2.model.DelegatedAdminAccount]
  type DetectionPlatforms = List[NonEmptyString]
  type DetectorTagList = List[NonEmptyString]
  type DisableResourceTypeList = List[zio.aws.inspector2.model.ResourceScanType]
  type EnableResourceTypeList = List[zio.aws.inspector2.model.ResourceScanType]
  type EvidenceList = List[zio.aws.inspector2.model.Evidence]
  type FailedAccountList = List[zio.aws.inspector2.model.FailedAccount]
  type FailedMemberAccountEc2DeepInspectionStatusStateList = List[
    zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
  ]
  type FilterArnList = List[FilterArn]
  type FilterList = List[zio.aws.inspector2.model.Filter]
  type FindingArnList = List[FindingArn]
  type FindingDetails = List[zio.aws.inspector2.model.FindingDetail]
  type FindingDetailsErrorList =
    List[zio.aws.inspector2.model.FindingDetailsError]
  type FindingList = List[zio.aws.inspector2.model.Finding]
  type FreeTrialAccountInfoList =
    List[zio.aws.inspector2.model.FreeTrialAccountInfo]
  type FreeTrialInfoErrorList =
    List[zio.aws.inspector2.model.FreeTrialInfoError]
  type FreeTrialInfoList = List[zio.aws.inspector2.model.FreeTrialInfo]
  type ImageTagList = List[NonEmptyString]
  type IpV4AddressList = List[IpV4Address]
  type IpV6AddressList = List[IpV6Address]
  type LambdaLayerList = List[String]
  type LayerList = List[LambdaLayerArn]
  type MapFilterList = List[zio.aws.inspector2.model.MapFilter]
  type MemberAccountEc2DeepInspectionStatusList =
    List[zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus]
  type MemberAccountEc2DeepInspectionStatusStateList =
    List[zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState]
  type MemberList = List[zio.aws.inspector2.model.Member]
  type NonEmptyStringList = List[NonEmptyString]
  type NumberFilterList = List[zio.aws.inspector2.model.NumberFilter]
  type OneAccountIdFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type PackageFilterList = List[zio.aws.inspector2.model.PackageFilter]
  type PathList = List[Path]
  type Permissions = List[zio.aws.inspector2.model.Permission]
  type PlatformFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type PortRangeFilterList = List[zio.aws.inspector2.model.PortRangeFilter]
  type ReferenceUrls = List[NonEmptyString]
  type RelatedVulnerabilities = List[RelatedVulnerability]
  type ReportTargetAccounts = List[AccountId]
  type ResourceIdFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type ResourceList = List[zio.aws.inspector2.model.Resource]
  type ResourceMapFilterList = List[zio.aws.inspector2.model.ResourceMapFilter]
  type ResourceStringFilterList =
    List[zio.aws.inspector2.model.ResourceStringFilter]
  type ResourceTagFilterList = List[zio.aws.inspector2.model.TagFilter]
  type SecurityGroupIdList = List[SecurityGroupId]
  type StepList = List[zio.aws.inspector2.model.Step]
  type StringFilterList = List[zio.aws.inspector2.model.StringFilter]
  type StringList = List[NonEmptyString]
  type SubnetIdList = List[SubnetId]
  type SuggestedFixes = List[zio.aws.inspector2.model.SuggestedFix]
  type TagKeyList = List[TagKey]
  type TagList = List[String]
  type TagMap = Map[MapKey, MapValue]
  type TagValueList = List[TargetResourceTagsValue]
  type TargetAccountList = List[TargetAccount]
  type TargetResourceTags =
    Map[TargetResourceTagsKey, Iterable[TargetResourceTagsValue]]
  type TargetStatusFilterList =
    List[zio.aws.inspector2.model.CisTargetStatusFilter]
  type TargetStatusReasonFilterList =
    List[zio.aws.inspector2.model.CisTargetStatusReasonFilter]
  type Targets = List[Target]
  type TitleFilterList = List[zio.aws.inspector2.model.CisStringFilter]
  type Tools = List[Tool]
  type Ttps = List[Ttp]
  type UsageAccountIdList = List[UsageAccountId]
  type UsageList = List[zio.aws.inspector2.model.Usage]
  type UsageTotalList = List[zio.aws.inspector2.model.UsageTotal]
  type VulnIdList = List[VulnId]
  type Vulnerabilities = List[zio.aws.inspector2.model.Vulnerability]
  type VulnerabilityIdList = List[VulnerabilityId]
  type VulnerabilityReferenceUrls = List[VulnerabilityReferenceUrl]
  type VulnerablePackageList = List[zio.aws.inspector2.model.VulnerablePackage]
}
