package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait AbortAction {
  def unwrap: software.amazon.awssdk.services.iot.model.AbortAction
}
object AbortAction {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AbortAction
  ): zio.aws.iot.model.AbortAction = value match {
    case software.amazon.awssdk.services.iot.model.AbortAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AbortAction.CANCEL =>
      val r = CANCEL
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.AbortAction {
    override def unwrap: software.amazon.awssdk.services.iot.model.AbortAction =
      software.amazon.awssdk.services.iot.model.AbortAction.UNKNOWN_TO_SDK_VERSION
  }
  case object CANCEL extends zio.aws.iot.model.AbortAction {
    override def unwrap: software.amazon.awssdk.services.iot.model.AbortAction =
      software.amazon.awssdk.services.iot.model.AbortAction.CANCEL
  }
}
