package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  MinimumNumberOfExecutedThings,
  AbortThresholdPercentage
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AbortCriteria(
    failureType: zio.aws.iot.model.JobExecutionFailureType,
    action: zio.aws.iot.model.AbortAction,
    thresholdPercentage: AbortThresholdPercentage,
    minNumberOfExecutedThings: MinimumNumberOfExecutedThings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AbortCriteria = {
    import AbortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AbortCriteria
      .builder()
      .failureType(failureType.unwrap)
      .action(action.unwrap)
      .thresholdPercentage(
        AbortThresholdPercentage.unwrap(thresholdPercentage): java.lang.Double
      )
      .minNumberOfExecutedThings(
        MinimumNumberOfExecutedThings.unwrap(minNumberOfExecutedThings): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AbortCriteria.ReadOnly =
    zio.aws.iot.model.AbortCriteria.wrap(buildAwsValue())
}
object AbortCriteria {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.AbortCriteria] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AbortCriteria =
      zio.aws.iot.model.AbortCriteria(
        failureType,
        action,
        thresholdPercentage,
        minNumberOfExecutedThings
      )
    def failureType: zio.aws.iot.model.JobExecutionFailureType
    def action: zio.aws.iot.model.AbortAction
    def thresholdPercentage: AbortThresholdPercentage
    def minNumberOfExecutedThings: MinimumNumberOfExecutedThings
    def getFailureType
        : ZIO[Any, Nothing, zio.aws.iot.model.JobExecutionFailureType] =
      ZIO.succeed(failureType)
    def getAction: ZIO[Any, Nothing, zio.aws.iot.model.AbortAction] =
      ZIO.succeed(action)
    def getThresholdPercentage: ZIO[Any, Nothing, AbortThresholdPercentage] =
      ZIO.succeed(thresholdPercentage)
    def getMinNumberOfExecutedThings
        : ZIO[Any, Nothing, MinimumNumberOfExecutedThings] =
      ZIO.succeed(minNumberOfExecutedThings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AbortCriteria
  ) extends zio.aws.iot.model.AbortCriteria.ReadOnly {
    override val failureType: zio.aws.iot.model.JobExecutionFailureType =
      zio.aws.iot.model.JobExecutionFailureType.wrap(impl.failureType())
    override val action: zio.aws.iot.model.AbortAction =
      zio.aws.iot.model.AbortAction.wrap(impl.action())
    override val thresholdPercentage: AbortThresholdPercentage =
      zio.aws.iot.model.primitives
        .AbortThresholdPercentage(impl.thresholdPercentage())
    override val minNumberOfExecutedThings: MinimumNumberOfExecutedThings =
      zio.aws.iot.model.primitives
        .MinimumNumberOfExecutedThings(impl.minNumberOfExecutedThings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AbortCriteria
  ): zio.aws.iot.model.AbortCriteria.ReadOnly = new Wrapper(impl)
}
