package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SetAsActive, CertificateId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptCertificateTransferRequest(
    certificateId: CertificateId,
    setAsActive: Optional[SetAsActive] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest = {
    import AcceptCertificateTransferRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .optionallyWith(
        setAsActive.map(value => SetAsActive.unwrap(value): java.lang.Boolean)
      )(_.setAsActive)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AcceptCertificateTransferRequest.ReadOnly =
    zio.aws.iot.model.AcceptCertificateTransferRequest.wrap(buildAwsValue())
}
object AcceptCertificateTransferRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AcceptCertificateTransferRequest =
      zio.aws.iot.model.AcceptCertificateTransferRequest(
        certificateId,
        setAsActive.map(value => value)
      )
    def certificateId: CertificateId
    def setAsActive: Optional[SetAsActive]
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
    def getSetAsActive: ZIO[Any, AwsError, SetAsActive] =
      AwsError.unwrapOptionField("setAsActive", setAsActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest
  ) extends zio.aws.iot.model.AcceptCertificateTransferRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
    override val setAsActive: Optional[SetAsActive] = zio.aws.core.internal
      .optionalFromNullable(impl.setAsActive())
      .map(value => zio.aws.iot.model.primitives.SetAsActive(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest
  ): zio.aws.iot.model.AcceptCertificateTransferRequest.ReadOnly = new Wrapper(
    impl
  )
}
