package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingArn,
  ThingName,
  BillingGroupArn,
  BillingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddThingToBillingGroupRequest(
    billingGroupName: Optional[BillingGroupName] = Optional.Absent,
    billingGroupArn: Optional[BillingGroupArn] = Optional.Absent,
    thingName: Optional[ThingName] = Optional.Absent,
    thingArn: Optional[ThingArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest = {
    import AddThingToBillingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest
      .builder()
      .optionallyWith(
        billingGroupName.map(value =>
          BillingGroupName.unwrap(value): java.lang.String
        )
      )(_.billingGroupName)
      .optionallyWith(
        billingGroupArn.map(value =>
          BillingGroupArn.unwrap(value): java.lang.String
        )
      )(_.billingGroupArn)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AddThingToBillingGroupRequest.ReadOnly =
    zio.aws.iot.model.AddThingToBillingGroupRequest.wrap(buildAwsValue())
}
object AddThingToBillingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AddThingToBillingGroupRequest =
      zio.aws.iot.model.AddThingToBillingGroupRequest(
        billingGroupName.map(value => value),
        billingGroupArn.map(value => value),
        thingName.map(value => value),
        thingArn.map(value => value)
      )
    def billingGroupName: Optional[BillingGroupName]
    def billingGroupArn: Optional[BillingGroupArn]
    def thingName: Optional[ThingName]
    def thingArn: Optional[ThingArn]
    def getBillingGroupName: ZIO[Any, AwsError, BillingGroupName] =
      AwsError.unwrapOptionField("billingGroupName", billingGroupName)
    def getBillingGroupArn: ZIO[Any, AwsError, BillingGroupArn] =
      AwsError.unwrapOptionField("billingGroupArn", billingGroupArn)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest
  ) extends zio.aws.iot.model.AddThingToBillingGroupRequest.ReadOnly {
    override val billingGroupName: Optional[BillingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupName())
        .map(value => zio.aws.iot.model.primitives.BillingGroupName(value))
    override val billingGroupArn: Optional[BillingGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupArn())
        .map(value => zio.aws.iot.model.primitives.BillingGroupArn(value))
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
    override val thingArn: Optional[ThingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest
  ): zio.aws.iot.model.AddThingToBillingGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
