package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RoleArn, AlertTargetArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AlertTarget(alertTargetArn: AlertTargetArn, roleArn: RoleArn) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.AlertTarget = {
    import AlertTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AlertTarget
      .builder()
      .alertTargetArn(AlertTargetArn.unwrap(alertTargetArn): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AlertTarget.ReadOnly =
    zio.aws.iot.model.AlertTarget.wrap(buildAwsValue())
}
object AlertTarget {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.AlertTarget] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AlertTarget =
      zio.aws.iot.model.AlertTarget(alertTargetArn, roleArn)
    def alertTargetArn: AlertTargetArn
    def roleArn: RoleArn
    def getAlertTargetArn: ZIO[Any, Nothing, AlertTargetArn] =
      ZIO.succeed(alertTargetArn)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AlertTarget
  ) extends zio.aws.iot.model.AlertTarget.ReadOnly {
    override val alertTargetArn: AlertTargetArn =
      zio.aws.iot.model.primitives.AlertTargetArn(impl.alertTargetArn())
    override val roleArn: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AlertTarget
  ): zio.aws.iot.model.AlertTarget.ReadOnly = new Wrapper(impl)
}
