package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait AlertTargetType {
  def unwrap: software.amazon.awssdk.services.iot.model.AlertTargetType
}
object AlertTargetType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AlertTargetType
  ): zio.aws.iot.model.AlertTargetType = value match {
    case software.amazon.awssdk.services.iot.model.AlertTargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AlertTargetType.SNS =>
      val r = SNS
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.AlertTargetType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AlertTargetType =
      software.amazon.awssdk.services.iot.model.AlertTargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object SNS extends zio.aws.iot.model.AlertTargetType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AlertTargetType =
      software.amazon.awssdk.services.iot.model.AlertTargetType.SNS
  }
}
