package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AssetPropertyBooleanValue,
  AssetPropertyDoubleValue,
  AssetPropertyIntegerValue,
  AssetPropertyStringValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetPropertyVariant(
    stringValue: Optional[AssetPropertyStringValue] = Optional.Absent,
    integerValue: Optional[AssetPropertyIntegerValue] = Optional.Absent,
    doubleValue: Optional[AssetPropertyDoubleValue] = Optional.Absent,
    booleanValue: Optional[AssetPropertyBooleanValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AssetPropertyVariant = {
    import AssetPropertyVariant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AssetPropertyVariant
      .builder()
      .optionallyWith(
        stringValue.map(value =>
          AssetPropertyStringValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        integerValue.map(value =>
          AssetPropertyIntegerValue.unwrap(value): java.lang.String
        )
      )(_.integerValue)
      .optionallyWith(
        doubleValue.map(value =>
          AssetPropertyDoubleValue.unwrap(value): java.lang.String
        )
      )(_.doubleValue)
      .optionallyWith(
        booleanValue.map(value =>
          AssetPropertyBooleanValue.unwrap(value): java.lang.String
        )
      )(_.booleanValue)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AssetPropertyVariant.ReadOnly =
    zio.aws.iot.model.AssetPropertyVariant.wrap(buildAwsValue())
}
object AssetPropertyVariant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AssetPropertyVariant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AssetPropertyVariant =
      zio.aws.iot.model.AssetPropertyVariant(
        stringValue.map(value => value),
        integerValue.map(value => value),
        doubleValue.map(value => value),
        booleanValue.map(value => value)
      )
    def stringValue: Optional[AssetPropertyStringValue]
    def integerValue: Optional[AssetPropertyIntegerValue]
    def doubleValue: Optional[AssetPropertyDoubleValue]
    def booleanValue: Optional[AssetPropertyBooleanValue]
    def getStringValue: ZIO[Any, AwsError, AssetPropertyStringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getIntegerValue: ZIO[Any, AwsError, AssetPropertyIntegerValue] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getDoubleValue: ZIO[Any, AwsError, AssetPropertyDoubleValue] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getBooleanValue: ZIO[Any, AwsError, AssetPropertyBooleanValue] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AssetPropertyVariant
  ) extends zio.aws.iot.model.AssetPropertyVariant.ReadOnly {
    override val stringValue: Optional[AssetPropertyStringValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringValue())
        .map(value =>
          zio.aws.iot.model.primitives.AssetPropertyStringValue(value)
        )
    override val integerValue: Optional[AssetPropertyIntegerValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integerValue())
        .map(value =>
          zio.aws.iot.model.primitives.AssetPropertyIntegerValue(value)
        )
    override val doubleValue: Optional[AssetPropertyDoubleValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.doubleValue())
        .map(value =>
          zio.aws.iot.model.primitives.AssetPropertyDoubleValue(value)
        )
    override val booleanValue: Optional[AssetPropertyBooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.booleanValue())
        .map(value =>
          zio.aws.iot.model.primitives.AssetPropertyBooleanValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AssetPropertyVariant
  ): zio.aws.iot.model.AssetPropertyVariant.ReadOnly = new Wrapper(impl)
}
