package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Flag, AttributeValue, AttributeName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttributePayload(
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    merge: Optional[Flag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AttributePayload = {
    import AttributePayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AttributePayload
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        merge.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.merge)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AttributePayload.ReadOnly =
    zio.aws.iot.model.AttributePayload.wrap(buildAwsValue())
}
object AttributePayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AttributePayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AttributePayload =
      zio.aws.iot.model.AttributePayload(
        attributes.map(value => value),
        merge.map(value => value)
      )
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def merge: Optional[Flag]
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getMerge: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("merge", merge)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AttributePayload
  ) extends zio.aws.iot.model.AttributePayload.ReadOnly {
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives.AttributeName(
                key
              ) -> zio.aws.iot.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val merge: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.merge())
      .map(value => zio.aws.iot.model.primitives.Flag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AttributePayload
  ): zio.aws.iot.model.AttributePayload.ReadOnly = new Wrapper(impl)
}
