package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait AuditCheckRunStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.AuditCheckRunStatus
}
object AuditCheckRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AuditCheckRunStatus
  ): zio.aws.iot.model.AuditCheckRunStatus = value match {
    case software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.WAITING_FOR_DATA_COLLECTION =>
      val r = WAITING_FOR_DATA_COLLECTION
      r
    case software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.COMPLETED_COMPLIANT =>
      val r = COMPLETED_COMPLIANT
      r
    case software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.COMPLETED_NON_COMPLIANT =>
      val r = COMPLETED_NON_COMPLIANT
      r
    case software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.AuditCheckRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditCheckRunStatus =
      software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.iot.model.AuditCheckRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditCheckRunStatus =
      software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.IN_PROGRESS
  }
  case object WAITING_FOR_DATA_COLLECTION
      extends zio.aws.iot.model.AuditCheckRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditCheckRunStatus =
      software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.WAITING_FOR_DATA_COLLECTION
  }
  case object CANCELED extends zio.aws.iot.model.AuditCheckRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditCheckRunStatus =
      software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.CANCELED
  }
  case object COMPLETED_COMPLIANT
      extends zio.aws.iot.model.AuditCheckRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditCheckRunStatus =
      software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.COMPLETED_COMPLIANT
  }
  case object COMPLETED_NON_COMPLIANT
      extends zio.aws.iot.model.AuditCheckRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditCheckRunStatus =
      software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.COMPLETED_NON_COMPLIANT
  }
  case object FAILED extends zio.aws.iot.model.AuditCheckRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditCheckRunStatus =
      software.amazon.awssdk.services.iot.model.AuditCheckRunStatus.FAILED
  }
}
