package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  AuditTaskId,
  ReasonForNonComplianceCode,
  Timestamp,
  AuditCheckName,
  ReasonForNonCompliance,
  IsSuppressed,
  FindingId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AuditFinding(
    findingId: Optional[FindingId] = Optional.Absent,
    taskId: Optional[AuditTaskId] = Optional.Absent,
    checkName: Optional[AuditCheckName] = Optional.Absent,
    taskStartTime: Optional[Timestamp] = Optional.Absent,
    findingTime: Optional[Timestamp] = Optional.Absent,
    severity: Optional[zio.aws.iot.model.AuditFindingSeverity] =
      Optional.Absent,
    nonCompliantResource: Optional[zio.aws.iot.model.NonCompliantResource] =
      Optional.Absent,
    relatedResources: Optional[Iterable[zio.aws.iot.model.RelatedResource]] =
      Optional.Absent,
    reasonForNonCompliance: Optional[ReasonForNonCompliance] = Optional.Absent,
    reasonForNonComplianceCode: Optional[ReasonForNonComplianceCode] =
      Optional.Absent,
    isSuppressed: Optional[IsSuppressed] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditFinding = {
    import AuditFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditFinding
      .builder()
      .optionallyWith(
        findingId.map(value => FindingId.unwrap(value): java.lang.String)
      )(_.findingId)
      .optionallyWith(
        taskId.map(value => AuditTaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        checkName.map(value => AuditCheckName.unwrap(value): java.lang.String)
      )(_.checkName)
      .optionallyWith(
        taskStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(
        findingTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.findingTime)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(nonCompliantResource.map(value => value.buildAwsValue()))(
        _.nonCompliantResource
      )
      .optionallyWith(
        relatedResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedResources)
      .optionallyWith(
        reasonForNonCompliance.map(value =>
          ReasonForNonCompliance.unwrap(value): java.lang.String
        )
      )(_.reasonForNonCompliance)
      .optionallyWith(
        reasonForNonComplianceCode.map(value =>
          ReasonForNonComplianceCode.unwrap(value): java.lang.String
        )
      )(_.reasonForNonComplianceCode)
      .optionallyWith(
        isSuppressed.map(value => IsSuppressed.unwrap(value): java.lang.Boolean)
      )(_.isSuppressed)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditFinding.ReadOnly =
    zio.aws.iot.model.AuditFinding.wrap(buildAwsValue())
}
object AuditFinding {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.AuditFinding] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditFinding =
      zio.aws.iot.model.AuditFinding(
        findingId.map(value => value),
        taskId.map(value => value),
        checkName.map(value => value),
        taskStartTime.map(value => value),
        findingTime.map(value => value),
        severity.map(value => value),
        nonCompliantResource.map(value => value.asEditable),
        relatedResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reasonForNonCompliance.map(value => value),
        reasonForNonComplianceCode.map(value => value),
        isSuppressed.map(value => value)
      )
    def findingId: Optional[FindingId]
    def taskId: Optional[AuditTaskId]
    def checkName: Optional[AuditCheckName]
    def taskStartTime: Optional[Timestamp]
    def findingTime: Optional[Timestamp]
    def severity: Optional[zio.aws.iot.model.AuditFindingSeverity]
    def nonCompliantResource
        : Optional[zio.aws.iot.model.NonCompliantResource.ReadOnly]
    def relatedResources
        : Optional[List[zio.aws.iot.model.RelatedResource.ReadOnly]]
    def reasonForNonCompliance: Optional[ReasonForNonCompliance]
    def reasonForNonComplianceCode: Optional[ReasonForNonComplianceCode]
    def isSuppressed: Optional[IsSuppressed]
    def getFindingId: ZIO[Any, AwsError, FindingId] =
      AwsError.unwrapOptionField("findingId", findingId)
    def getTaskId: ZIO[Any, AwsError, AuditTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getCheckName: ZIO[Any, AwsError, AuditCheckName] =
      AwsError.unwrapOptionField("checkName", checkName)
    def getTaskStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getFindingTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("findingTime", findingTime)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.iot.model.AuditFindingSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getNonCompliantResource
        : ZIO[Any, AwsError, zio.aws.iot.model.NonCompliantResource.ReadOnly] =
      AwsError.unwrapOptionField("nonCompliantResource", nonCompliantResource)
    def getRelatedResources
        : ZIO[Any, AwsError, List[zio.aws.iot.model.RelatedResource.ReadOnly]] =
      AwsError.unwrapOptionField("relatedResources", relatedResources)
    def getReasonForNonCompliance: ZIO[Any, AwsError, ReasonForNonCompliance] =
      AwsError.unwrapOptionField(
        "reasonForNonCompliance",
        reasonForNonCompliance
      )
    def getReasonForNonComplianceCode
        : ZIO[Any, AwsError, ReasonForNonComplianceCode] =
      AwsError.unwrapOptionField(
        "reasonForNonComplianceCode",
        reasonForNonComplianceCode
      )
    def getIsSuppressed: ZIO[Any, AwsError, IsSuppressed] =
      AwsError.unwrapOptionField("isSuppressed", isSuppressed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditFinding
  ) extends zio.aws.iot.model.AuditFinding.ReadOnly {
    override val findingId: Optional[FindingId] = zio.aws.core.internal
      .optionalFromNullable(impl.findingId())
      .map(value => zio.aws.iot.model.primitives.FindingId(value))
    override val taskId: Optional[AuditTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.AuditTaskId(value))
    override val checkName: Optional[AuditCheckName] = zio.aws.core.internal
      .optionalFromNullable(impl.checkName())
      .map(value => zio.aws.iot.model.primitives.AuditCheckName(value))
    override val taskStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.taskStartTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val findingTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.findingTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val severity: Optional[zio.aws.iot.model.AuditFindingSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.iot.model.AuditFindingSeverity.wrap(value))
    override val nonCompliantResource
        : Optional[zio.aws.iot.model.NonCompliantResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantResource())
        .map(value => zio.aws.iot.model.NonCompliantResource.wrap(value))
    override val relatedResources
        : Optional[List[zio.aws.iot.model.RelatedResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.RelatedResource.wrap(item)
          }.toList
        )
    override val reasonForNonCompliance: Optional[ReasonForNonCompliance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reasonForNonCompliance())
        .map(value =>
          zio.aws.iot.model.primitives.ReasonForNonCompliance(value)
        )
    override val reasonForNonComplianceCode
        : Optional[ReasonForNonComplianceCode] = zio.aws.core.internal
      .optionalFromNullable(impl.reasonForNonComplianceCode())
      .map(value =>
        zio.aws.iot.model.primitives.ReasonForNonComplianceCode(value)
      )
    override val isSuppressed: Optional[IsSuppressed] = zio.aws.core.internal
      .optionalFromNullable(impl.isSuppressed())
      .map(value => zio.aws.iot.model.primitives.IsSuppressed(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditFinding
  ): zio.aws.iot.model.AuditFinding.ReadOnly = new Wrapper(impl)
}
