package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ReasonForNonComplianceCode,
  AuditCheckName,
  FindingId,
  AuditTaskId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuditMitigationActionsTaskTarget(
    auditTaskId: Optional[AuditTaskId] = Optional.Absent,
    findingIds: Optional[Iterable[FindingId]] = Optional.Absent,
    auditCheckToReasonCodeFilter: Optional[
      Map[AuditCheckName, Iterable[ReasonForNonComplianceCode]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskTarget = {
    import AuditMitigationActionsTaskTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskTarget
      .builder()
      .optionallyWith(
        auditTaskId.map(value => AuditTaskId.unwrap(value): java.lang.String)
      )(_.auditTaskId)
      .optionallyWith(
        findingIds.map(value =>
          value.map { item =>
            FindingId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.findingIds)
      .optionallyWith(
        auditCheckToReasonCodeFilter.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ReasonForNonComplianceCode.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.auditCheckToReasonCodeFilter)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly =
    zio.aws.iot.model.AuditMitigationActionsTaskTarget.wrap(buildAwsValue())
}
object AuditMitigationActionsTaskTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditMitigationActionsTaskTarget =
      zio.aws.iot.model.AuditMitigationActionsTaskTarget(
        auditTaskId.map(value => value),
        findingIds.map(value => value),
        auditCheckToReasonCodeFilter.map(value => value)
      )
    def auditTaskId: Optional[AuditTaskId]
    def findingIds: Optional[List[FindingId]]
    def auditCheckToReasonCodeFilter
        : Optional[Map[AuditCheckName, List[ReasonForNonComplianceCode]]]
    def getAuditTaskId: ZIO[Any, AwsError, AuditTaskId] =
      AwsError.unwrapOptionField("auditTaskId", auditTaskId)
    def getFindingIds: ZIO[Any, AwsError, List[FindingId]] =
      AwsError.unwrapOptionField("findingIds", findingIds)
    def getAuditCheckToReasonCodeFilter
        : ZIO[Any, AwsError, Map[AuditCheckName, List[
          ReasonForNonComplianceCode
        ]]] = AwsError.unwrapOptionField(
      "auditCheckToReasonCodeFilter",
      auditCheckToReasonCodeFilter
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskTarget
  ) extends zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly {
    override val auditTaskId: Optional[AuditTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.auditTaskId())
      .map(value => zio.aws.iot.model.primitives.AuditTaskId(value))
    override val findingIds: Optional[List[FindingId]] = zio.aws.core.internal
      .optionalFromNullable(impl.findingIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.FindingId(item)
        }.toList
      )
    override val auditCheckToReasonCodeFilter
        : Optional[Map[AuditCheckName, List[ReasonForNonComplianceCode]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditCheckToReasonCodeFilter())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives
                .AuditCheckName(key) -> value.asScala.map { item =>
                zio.aws.iot.model.primitives.ReasonForNonComplianceCode(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskTarget
  ): zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly = new Wrapper(
    impl
  )
}
