package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Enabled, RoleArn, TargetArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuditNotificationTarget(
    targetArn: Optional[TargetArn] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    enabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditNotificationTarget = {
    import AuditNotificationTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditNotificationTarget
      .builder()
      .optionallyWith(
        targetArn.map(value => TargetArn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditNotificationTarget.ReadOnly =
    zio.aws.iot.model.AuditNotificationTarget.wrap(buildAwsValue())
}
object AuditNotificationTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditNotificationTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditNotificationTarget =
      zio.aws.iot.model.AuditNotificationTarget(
        targetArn.map(value => value),
        roleArn.map(value => value),
        enabled.map(value => value)
      )
    def targetArn: Optional[TargetArn]
    def roleArn: Optional[RoleArn]
    def enabled: Optional[Enabled]
    def getTargetArn: ZIO[Any, AwsError, TargetArn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditNotificationTarget
  ) extends zio.aws.iot.model.AuditNotificationTarget.ReadOnly {
    override val targetArn: Optional[TargetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.iot.model.primitives.TargetArn(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditNotificationTarget
  ): zio.aws.iot.model.AuditNotificationTarget.ReadOnly = new Wrapper(impl)
}
