package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait AuditNotificationType {
  def unwrap: software.amazon.awssdk.services.iot.model.AuditNotificationType
}
object AuditNotificationType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AuditNotificationType
  ): zio.aws.iot.model.AuditNotificationType = value match {
    case software.amazon.awssdk.services.iot.model.AuditNotificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AuditNotificationType.SNS =>
      val r = SNS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.AuditNotificationType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditNotificationType =
      software.amazon.awssdk.services.iot.model.AuditNotificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object SNS extends zio.aws.iot.model.AuditNotificationType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditNotificationType =
      software.amazon.awssdk.services.iot.model.AuditNotificationType.SNS
  }
}
