package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait AuditTaskStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.AuditTaskStatus
}
object AuditTaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AuditTaskStatus
  ): zio.aws.iot.model.AuditTaskStatus = value match {
    case software.amazon.awssdk.services.iot.model.AuditTaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AuditTaskStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iot.model.AuditTaskStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.iot.model.AuditTaskStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iot.model.AuditTaskStatus.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.AuditTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditTaskStatus =
      software.amazon.awssdk.services.iot.model.AuditTaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.iot.model.AuditTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditTaskStatus =
      software.amazon.awssdk.services.iot.model.AuditTaskStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.iot.model.AuditTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditTaskStatus =
      software.amazon.awssdk.services.iot.model.AuditTaskStatus.COMPLETED
  }
  case object FAILED extends zio.aws.iot.model.AuditTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditTaskStatus =
      software.amazon.awssdk.services.iot.model.AuditTaskStatus.FAILED
  }
  case object CANCELED extends zio.aws.iot.model.AuditTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditTaskStatus =
      software.amazon.awssdk.services.iot.model.AuditTaskStatus.CANCELED
  }
}
