package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait AuditTaskType {
  def unwrap: software.amazon.awssdk.services.iot.model.AuditTaskType
}
object AuditTaskType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AuditTaskType
  ): zio.aws.iot.model.AuditTaskType = value match {
    case software.amazon.awssdk.services.iot.model.AuditTaskType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AuditTaskType.ON_DEMAND_AUDIT_TASK =>
      val r = ON_DEMAND_AUDIT_TASK
      r
    case software.amazon.awssdk.services.iot.model.AuditTaskType.SCHEDULED_AUDIT_TASK =>
      val r = SCHEDULED_AUDIT_TASK
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.AuditTaskType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditTaskType =
      software.amazon.awssdk.services.iot.model.AuditTaskType.UNKNOWN_TO_SDK_VERSION
  }
  case object ON_DEMAND_AUDIT_TASK extends zio.aws.iot.model.AuditTaskType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditTaskType =
      software.amazon.awssdk.services.iot.model.AuditTaskType.ON_DEMAND_AUDIT_TASK
  }
  case object SCHEDULED_AUDIT_TASK extends zio.aws.iot.model.AuditTaskType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditTaskType =
      software.amazon.awssdk.services.iot.model.AuditTaskType.SCHEDULED_AUDIT_TASK
  }
}
