package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait AuthDecision {
  def unwrap: software.amazon.awssdk.services.iot.model.AuthDecision
}
object AuthDecision {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AuthDecision
  ): zio.aws.iot.model.AuthDecision = value match {
    case software.amazon.awssdk.services.iot.model.AuthDecision.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AuthDecision.ALLOWED =>
      val r = ALLOWED
      r
    case software.amazon.awssdk.services.iot.model.AuthDecision.EXPLICIT_DENY =>
      val r = EXPLICIT_DENY
      r
    case software.amazon.awssdk.services.iot.model.AuthDecision.IMPLICIT_DENY =>
      val r = IMPLICIT_DENY
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.AuthDecision {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuthDecision =
      software.amazon.awssdk.services.iot.model.AuthDecision.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOWED extends zio.aws.iot.model.AuthDecision {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuthDecision =
      software.amazon.awssdk.services.iot.model.AuthDecision.ALLOWED
  }
  case object EXPLICIT_DENY extends zio.aws.iot.model.AuthDecision {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuthDecision =
      software.amazon.awssdk.services.iot.model.AuthDecision.EXPLICIT_DENY
  }
  case object IMPLICIT_DENY extends zio.aws.iot.model.AuthDecision {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuthDecision =
      software.amazon.awssdk.services.iot.model.AuthDecision.IMPLICIT_DENY
  }
}
