package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AwsJobAbortCriteriaMinimumNumberOfExecutedThings,
  AwsJobAbortCriteriaAbortThresholdPercentage
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AwsJobAbortCriteria(
    failureType: zio.aws.iot.model.AwsJobAbortCriteriaFailureType,
    action: zio.aws.iot.model.AwsJobAbortCriteriaAbortAction,
    thresholdPercentage: AwsJobAbortCriteriaAbortThresholdPercentage,
    minNumberOfExecutedThings: AwsJobAbortCriteriaMinimumNumberOfExecutedThings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AwsJobAbortCriteria = {
    import AwsJobAbortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AwsJobAbortCriteria
      .builder()
      .failureType(failureType.unwrap)
      .action(action.unwrap)
      .thresholdPercentage(
        AwsJobAbortCriteriaAbortThresholdPercentage.unwrap(
          thresholdPercentage
        ): java.lang.Double
      )
      .minNumberOfExecutedThings(
        AwsJobAbortCriteriaMinimumNumberOfExecutedThings.unwrap(
          minNumberOfExecutedThings
        ): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AwsJobAbortCriteria.ReadOnly =
    zio.aws.iot.model.AwsJobAbortCriteria.wrap(buildAwsValue())
}
object AwsJobAbortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AwsJobAbortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AwsJobAbortCriteria =
      zio.aws.iot.model.AwsJobAbortCriteria(
        failureType,
        action,
        thresholdPercentage,
        minNumberOfExecutedThings
      )
    def failureType: zio.aws.iot.model.AwsJobAbortCriteriaFailureType
    def action: zio.aws.iot.model.AwsJobAbortCriteriaAbortAction
    def thresholdPercentage: AwsJobAbortCriteriaAbortThresholdPercentage
    def minNumberOfExecutedThings
        : AwsJobAbortCriteriaMinimumNumberOfExecutedThings
    def getFailureType
        : ZIO[Any, Nothing, zio.aws.iot.model.AwsJobAbortCriteriaFailureType] =
      ZIO.succeed(failureType)
    def getAction
        : ZIO[Any, Nothing, zio.aws.iot.model.AwsJobAbortCriteriaAbortAction] =
      ZIO.succeed(action)
    def getThresholdPercentage
        : ZIO[Any, Nothing, AwsJobAbortCriteriaAbortThresholdPercentage] =
      ZIO.succeed(thresholdPercentage)
    def getMinNumberOfExecutedThings
        : ZIO[Any, Nothing, AwsJobAbortCriteriaMinimumNumberOfExecutedThings] =
      ZIO.succeed(minNumberOfExecutedThings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AwsJobAbortCriteria
  ) extends zio.aws.iot.model.AwsJobAbortCriteria.ReadOnly {
    override val failureType: zio.aws.iot.model.AwsJobAbortCriteriaFailureType =
      zio.aws.iot.model.AwsJobAbortCriteriaFailureType.wrap(impl.failureType())
    override val action: zio.aws.iot.model.AwsJobAbortCriteriaAbortAction =
      zio.aws.iot.model.AwsJobAbortCriteriaAbortAction.wrap(impl.action())
    override val thresholdPercentage
        : AwsJobAbortCriteriaAbortThresholdPercentage =
      zio.aws.iot.model.primitives
        .AwsJobAbortCriteriaAbortThresholdPercentage(impl.thresholdPercentage())
    override val minNumberOfExecutedThings
        : AwsJobAbortCriteriaMinimumNumberOfExecutedThings =
      zio.aws.iot.model.primitives
        .AwsJobAbortCriteriaMinimumNumberOfExecutedThings(
          impl.minNumberOfExecutedThings()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AwsJobAbortCriteria
  ): zio.aws.iot.model.AwsJobAbortCriteria.ReadOnly = new Wrapper(impl)
}
